// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> State of the update run. </summary>
    public readonly partial struct UpdateRunPropertiesState : IEquatable<UpdateRunPropertiesState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="UpdateRunPropertiesState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public UpdateRunPropertiesState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string SucceededValue = "Succeeded";
        private const string InProgressValue = "InProgress";
        private const string FailedValue = "Failed";

        /// <summary> Unknown. </summary>
        public static UpdateRunPropertiesState Unknown { get; } = new UpdateRunPropertiesState(UnknownValue);
        /// <summary> Succeeded. </summary>
        public static UpdateRunPropertiesState Succeeded { get; } = new UpdateRunPropertiesState(SucceededValue);
        /// <summary> InProgress. </summary>
        public static UpdateRunPropertiesState InProgress { get; } = new UpdateRunPropertiesState(InProgressValue);
        /// <summary> Failed. </summary>
        public static UpdateRunPropertiesState Failed { get; } = new UpdateRunPropertiesState(FailedValue);
        /// <summary> Determines if two <see cref="UpdateRunPropertiesState"/> values are the same. </summary>
        public static bool operator ==(UpdateRunPropertiesState left, UpdateRunPropertiesState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="UpdateRunPropertiesState"/> values are not the same. </summary>
        public static bool operator !=(UpdateRunPropertiesState left, UpdateRunPropertiesState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="UpdateRunPropertiesState"/>. </summary>
        public static implicit operator UpdateRunPropertiesState(string value) => new UpdateRunPropertiesState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is UpdateRunPropertiesState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(UpdateRunPropertiesState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
