// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> Customer Intent for Software Assurance Benefit. </summary>
    public readonly partial struct SoftwareAssuranceIntent : IEquatable<SoftwareAssuranceIntent>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="SoftwareAssuranceIntent"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public SoftwareAssuranceIntent(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnableValue = "Enable";
        private const string DisableValue = "Disable";

        /// <summary> Enable. </summary>
        public static SoftwareAssuranceIntent Enable { get; } = new SoftwareAssuranceIntent(EnableValue);
        /// <summary> Disable. </summary>
        public static SoftwareAssuranceIntent Disable { get; } = new SoftwareAssuranceIntent(DisableValue);
        /// <summary> Determines if two <see cref="SoftwareAssuranceIntent"/> values are the same. </summary>
        public static bool operator ==(SoftwareAssuranceIntent left, SoftwareAssuranceIntent right) => left.Equals(right);
        /// <summary> Determines if two <see cref="SoftwareAssuranceIntent"/> values are not the same. </summary>
        public static bool operator !=(SoftwareAssuranceIntent left, SoftwareAssuranceIntent right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="SoftwareAssuranceIntent"/>. </summary>
        public static implicit operator SoftwareAssuranceIntent(string value) => new SoftwareAssuranceIntent(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is SoftwareAssuranceIntent other && Equals(other);
        /// <inheritdoc />
        public bool Equals(SoftwareAssuranceIntent other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
