// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Hci.Models
{
    public partial class SecurityComplianceStatus : IUtf8JsonSerializable, IJsonModel<SecurityComplianceStatus>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SecurityComplianceStatus>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SecurityComplianceStatus>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecurityComplianceStatus>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SecurityComplianceStatus)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(SecuredCoreCompliance))
            {
                writer.WritePropertyName("securedCoreCompliance"u8);
                writer.WriteStringValue(SecuredCoreCompliance.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(WdacCompliance))
            {
                writer.WritePropertyName("wdacCompliance"u8);
                writer.WriteStringValue(WdacCompliance.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(DataAtRestEncrypted))
            {
                writer.WritePropertyName("dataAtRestEncrypted"u8);
                writer.WriteStringValue(DataAtRestEncrypted.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(DataInTransitProtected))
            {
                writer.WritePropertyName("dataInTransitProtected"u8);
                writer.WriteStringValue(DataInTransitProtected.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(LastUpdatedOn))
            {
                writer.WritePropertyName("lastUpdated"u8);
                writer.WriteStringValue(LastUpdatedOn.Value, "O");
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        SecurityComplianceStatus IJsonModel<SecurityComplianceStatus>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecurityComplianceStatus>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SecurityComplianceStatus)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSecurityComplianceStatus(document.RootElement, options);
        }

        internal static SecurityComplianceStatus DeserializeSecurityComplianceStatus(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            HciClusterComplianceStatus? securedCoreCompliance = default;
            HciClusterComplianceStatus? wdacCompliance = default;
            HciClusterComplianceStatus? dataAtRestEncrypted = default;
            HciClusterComplianceStatus? dataInTransitProtected = default;
            DateTimeOffset? lastUpdated = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("securedCoreCompliance"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    securedCoreCompliance = new HciClusterComplianceStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("wdacCompliance"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    wdacCompliance = new HciClusterComplianceStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("dataAtRestEncrypted"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dataAtRestEncrypted = new HciClusterComplianceStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("dataInTransitProtected"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    dataInTransitProtected = new HciClusterComplianceStatus(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("lastUpdated"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastUpdated = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SecurityComplianceStatus(
                securedCoreCompliance,
                wdacCompliance,
                dataAtRestEncrypted,
                dataInTransitProtected,
                lastUpdated,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SecuredCoreCompliance), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  securedCoreCompliance: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SecuredCoreCompliance))
                {
                    builder.Append("  securedCoreCompliance: ");
                    builder.AppendLine($"'{SecuredCoreCompliance.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(WdacCompliance), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  wdacCompliance: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(WdacCompliance))
                {
                    builder.Append("  wdacCompliance: ");
                    builder.AppendLine($"'{WdacCompliance.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DataAtRestEncrypted), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  dataAtRestEncrypted: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DataAtRestEncrypted))
                {
                    builder.Append("  dataAtRestEncrypted: ");
                    builder.AppendLine($"'{DataAtRestEncrypted.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DataInTransitProtected), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  dataInTransitProtected: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DataInTransitProtected))
                {
                    builder.Append("  dataInTransitProtected: ");
                    builder.AppendLine($"'{DataInTransitProtected.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LastUpdatedOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  lastUpdated: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LastUpdatedOn))
                {
                    builder.Append("  lastUpdated: ");
                    var formattedDateTimeString = TypeFormatters.ToString(LastUpdatedOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<SecurityComplianceStatus>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecurityComplianceStatus>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(SecurityComplianceStatus)} does not support writing '{options.Format}' format.");
            }
        }

        SecurityComplianceStatus IPersistableModel<SecurityComplianceStatus>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SecurityComplianceStatus>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSecurityComplianceStatus(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SecurityComplianceStatus)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SecurityComplianceStatus>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
