// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Hci.Models
{
    public partial class SbePartnerInfo : IUtf8JsonSerializable, IJsonModel<SbePartnerInfo>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<SbePartnerInfo>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<SbePartnerInfo>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SbePartnerInfo>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SbePartnerInfo)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(SbeDeploymentInfo))
            {
                writer.WritePropertyName("sbeDeploymentInfo"u8);
                writer.WriteObjectValue(SbeDeploymentInfo, options);
            }
            if (Optional.IsCollectionDefined(PartnerProperties))
            {
                writer.WritePropertyName("partnerProperties"u8);
                writer.WriteStartArray();
                foreach (var item in PartnerProperties)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (Optional.IsCollectionDefined(CredentialList))
            {
                writer.WritePropertyName("credentialList"u8);
                writer.WriteStartArray();
                foreach (var item in CredentialList)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        SbePartnerInfo IJsonModel<SbePartnerInfo>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SbePartnerInfo>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(SbePartnerInfo)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeSbePartnerInfo(document.RootElement, options);
        }

        internal static SbePartnerInfo DeserializeSbePartnerInfo(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            SbeDeploymentInfo sbeDeploymentInfo = default;
            IList<SbePartnerProperties> partnerProperties = default;
            IList<SbeCredentials> credentialList = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("sbeDeploymentInfo"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sbeDeploymentInfo = SbeDeploymentInfo.DeserializeSbeDeploymentInfo(property.Value, options);
                    continue;
                }
                if (property.NameEquals("partnerProperties"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SbePartnerProperties> array = new List<SbePartnerProperties>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SbePartnerProperties.DeserializeSbePartnerProperties(item, options));
                    }
                    partnerProperties = array;
                    continue;
                }
                if (property.NameEquals("credentialList"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<SbeCredentials> array = new List<SbeCredentials>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(SbeCredentials.DeserializeSbeCredentials(item, options));
                    }
                    credentialList = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new SbePartnerInfo(sbeDeploymentInfo, partnerProperties ?? new ChangeTrackingList<SbePartnerProperties>(), credentialList ?? new ChangeTrackingList<SbeCredentials>(), serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SbeDeploymentInfo), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  sbeDeploymentInfo: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SbeDeploymentInfo))
                {
                    builder.Append("  sbeDeploymentInfo: ");
                    BicepSerializationHelpers.AppendChildObject(builder, SbeDeploymentInfo, options, 2, false, "  sbeDeploymentInfo: ");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(PartnerProperties), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  partnerProperties: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(PartnerProperties))
                {
                    if (PartnerProperties.Any())
                    {
                        builder.Append("  partnerProperties: ");
                        builder.AppendLine("[");
                        foreach (var item in PartnerProperties)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  partnerProperties: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(CredentialList), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  credentialList: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(CredentialList))
                {
                    if (CredentialList.Any())
                    {
                        builder.Append("  credentialList: ");
                        builder.AppendLine("[");
                        foreach (var item in CredentialList)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  credentialList: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<SbePartnerInfo>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SbePartnerInfo>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(SbePartnerInfo)} does not support writing '{options.Format}' format.");
            }
        }

        SbePartnerInfo IPersistableModel<SbePartnerInfo>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<SbePartnerInfo>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeSbePartnerInfo(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(SbePartnerInfo)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<SbePartnerInfo>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
