// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> Solution builder extension (SBE) deployment package information. </summary>
    public partial class SbeDeploymentPackageInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SbeDeploymentPackageInfo"/>. </summary>
        internal SbeDeploymentPackageInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SbeDeploymentPackageInfo"/>. </summary>
        /// <param name="code"> SBE deployment validation code. </param>
        /// <param name="message"> A detailed message that explains the SBE package validation result. </param>
        /// <param name="sbeManifest"> This represents discovered update results for matching updates and store it as SBE manifest. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SbeDeploymentPackageInfo(string code, string message, string sbeManifest, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Code = code;
            Message = message;
            SbeManifest = sbeManifest;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> SBE deployment validation code. </summary>
        [WirePath("code")]
        public string Code { get; }
        /// <summary> A detailed message that explains the SBE package validation result. </summary>
        [WirePath("message")]
        public string Message { get; }
        /// <summary> This represents discovered update results for matching updates and store it as SBE manifest. </summary>
        [WirePath("sbeManifest")]
        public string SbeManifest { get; }
    }
}
