// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> secrets used for solution builder extension (SBE) partner extensibility. </summary>
    public partial class SbeCredentials
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="SbeCredentials"/>. </summary>
        public SbeCredentials()
        {
        }

        /// <summary> Initializes a new instance of <see cref="SbeCredentials"/>. </summary>
        /// <param name="secretName"> secret name stored in keyvault. </param>
        /// <param name="eceSecretName"> secret name expected for Enterprise Cloud Engine (ECE). </param>
        /// <param name="secretLocation"> secret URI stored in keyvault. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal SbeCredentials(string secretName, string eceSecretName, Uri secretLocation, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SecretName = secretName;
            EceSecretName = eceSecretName;
            SecretLocation = secretLocation;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> secret name stored in keyvault. </summary>
        [WirePath("secretName")]
        public string SecretName { get; set; }
        /// <summary> secret name expected for Enterprise Cloud Engine (ECE). </summary>
        [WirePath("eceSecretName")]
        public string EceSecretName { get; set; }
        /// <summary> secret URI stored in keyvault. </summary>
        [WirePath("secretLocation")]
        public Uri SecretLocation { get; set; }
    }
}
