// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> Remote Support Type for cluster. </summary>
    public readonly partial struct RemoteSupportType : IEquatable<RemoteSupportType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="RemoteSupportType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public RemoteSupportType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string EnableValue = "Enable";
        private const string RevokeValue = "Revoke";

        /// <summary> Enable. </summary>
        public static RemoteSupportType Enable { get; } = new RemoteSupportType(EnableValue);
        /// <summary> Revoke. </summary>
        public static RemoteSupportType Revoke { get; } = new RemoteSupportType(RevokeValue);
        /// <summary> Determines if two <see cref="RemoteSupportType"/> values are the same. </summary>
        public static bool operator ==(RemoteSupportType left, RemoteSupportType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="RemoteSupportType"/> values are not the same. </summary>
        public static bool operator !=(RemoteSupportType left, RemoteSupportType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="RemoteSupportType"/>. </summary>
        public static implicit operator RemoteSupportType(string value) => new RemoteSupportType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is RemoteSupportType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(RemoteSupportType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
