// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> Remote Support properties of the cluster. </summary>
    public partial class RemoteSupportProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RemoteSupportProperties"/>. </summary>
        public RemoteSupportProperties()
        {
            RemoteSupportNodeSettings = new ChangeTrackingList<RemoteSupportNodeSettings>();
            RemoteSupportSessionDetails = new ChangeTrackingList<PerNodeRemoteSupportSession>();
        }

        /// <summary> Initializes a new instance of <see cref="RemoteSupportProperties"/>. </summary>
        /// <param name="accessLevel"> Remote Support Access Level. </param>
        /// <param name="expireOn"> Expiration DateTimeStamp when Remote Support Access will be expired. </param>
        /// <param name="remoteSupportType"> Remote Support Type for cluster. </param>
        /// <param name="remoteSupportNodeSettings"></param>
        /// <param name="remoteSupportSessionDetails"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RemoteSupportProperties(HciClusterAccessLevel? accessLevel, DateTimeOffset? expireOn, RemoteSupportType? remoteSupportType, IReadOnlyList<RemoteSupportNodeSettings> remoteSupportNodeSettings, IReadOnlyList<PerNodeRemoteSupportSession> remoteSupportSessionDetails, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AccessLevel = accessLevel;
            ExpireOn = expireOn;
            RemoteSupportType = remoteSupportType;
            RemoteSupportNodeSettings = remoteSupportNodeSettings;
            RemoteSupportSessionDetails = remoteSupportSessionDetails;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Remote Support Access Level. </summary>
        [WirePath("accessLevel")]
        public HciClusterAccessLevel? AccessLevel { get; }
        /// <summary> Expiration DateTimeStamp when Remote Support Access will be expired. </summary>
        [WirePath("expirationTimeStamp")]
        public DateTimeOffset? ExpireOn { get; }
        /// <summary> Remote Support Type for cluster. </summary>
        [WirePath("remoteSupportType")]
        public RemoteSupportType? RemoteSupportType { get; }
        /// <summary> Gets the remote support node settings. </summary>
        [WirePath("remoteSupportNodeSettings")]
        public IReadOnlyList<RemoteSupportNodeSettings> RemoteSupportNodeSettings { get; }
        /// <summary> Gets the remote support session details. </summary>
        [WirePath("remoteSupportSessionDetails")]
        public IReadOnlyList<PerNodeRemoteSupportSession> RemoteSupportSessionDetails { get; }
    }
}
