// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> Remote Support Node Settings of the cluster. </summary>
    public partial class RemoteSupportNodeSettings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RemoteSupportNodeSettings"/>. </summary>
        internal RemoteSupportNodeSettings()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RemoteSupportNodeSettings"/>. </summary>
        /// <param name="arcResourceId"> Arc ResourceId of the Node. </param>
        /// <param name="state"> Remote Support Access Connection State on the Node. </param>
        /// <param name="createdOn"> Remote Support Enablement Request Created TimeStamp on the Node. </param>
        /// <param name="updatedOn"> Remote Support Enablement Request Updated TimeStamp on the Node. </param>
        /// <param name="connectionStatus"> Remote Support Access Connection Status on the Node. </param>
        /// <param name="connectionErrorMessage"> Remote Support Access Connection Error Message on the Node. </param>
        /// <param name="transcriptLocation"> Remote Support Transcript location on the node. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RemoteSupportNodeSettings(ResourceIdentifier arcResourceId, string state, DateTimeOffset? createdOn, DateTimeOffset? updatedOn, string connectionStatus, string connectionErrorMessage, string transcriptLocation, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ArcResourceId = arcResourceId;
            State = state;
            CreatedOn = createdOn;
            UpdatedOn = updatedOn;
            ConnectionStatus = connectionStatus;
            ConnectionErrorMessage = connectionErrorMessage;
            TranscriptLocation = transcriptLocation;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Arc ResourceId of the Node. </summary>
        [WirePath("arcResourceId")]
        public ResourceIdentifier ArcResourceId { get; }
        /// <summary> Remote Support Access Connection State on the Node. </summary>
        [WirePath("state")]
        public string State { get; }
        /// <summary> Remote Support Enablement Request Created TimeStamp on the Node. </summary>
        [WirePath("createdAt")]
        public DateTimeOffset? CreatedOn { get; }
        /// <summary> Remote Support Enablement Request Updated TimeStamp on the Node. </summary>
        [WirePath("updatedAt")]
        public DateTimeOffset? UpdatedOn { get; }
        /// <summary> Remote Support Access Connection Status on the Node. </summary>
        [WirePath("connectionStatus")]
        public string ConnectionStatus { get; }
        /// <summary> Remote Support Access Connection Error Message on the Node. </summary>
        [WirePath("connectionErrorMessage")]
        public string ConnectionErrorMessage { get; }
        /// <summary> Remote Support Transcript location on the node. </summary>
        [WirePath("transcriptLocation")]
        public string TranscriptLocation { get; }
    }
}
