// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> Properties for Remote Support Request. </summary>
    public partial class RemoteSupportContentProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="RemoteSupportContentProperties"/>. </summary>
        public RemoteSupportContentProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="RemoteSupportContentProperties"/>. </summary>
        /// <param name="accessLevel"> Remote Support Access Level. </param>
        /// <param name="expireOn"> Expiration DateTimeStamp when Remote Support Access will be expired. </param>
        /// <param name="remoteSupportType"> Remote Support Type for cluster. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal RemoteSupportContentProperties(HciClusterAccessLevel? accessLevel, DateTimeOffset? expireOn, RemoteSupportType? remoteSupportType, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AccessLevel = accessLevel;
            ExpireOn = expireOn;
            RemoteSupportType = remoteSupportType;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Remote Support Access Level. </summary>
        [WirePath("accessLevel")]
        public HciClusterAccessLevel? AccessLevel { get; }
        /// <summary> Expiration DateTimeStamp when Remote Support Access will be expired. </summary>
        [WirePath("expirationTimeStamp")]
        public DateTimeOffset? ExpireOn { get; set; }
        /// <summary> Remote Support Type for cluster. </summary>
        [WirePath("remoteSupportType")]
        public RemoteSupportType? RemoteSupportType { get; set; }
    }
}
