// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> Remote Support Node Session Details on the Node. </summary>
    public partial class PerNodeRemoteSupportSession
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PerNodeRemoteSupportSession"/>. </summary>
        internal PerNodeRemoteSupportSession()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PerNodeRemoteSupportSession"/>. </summary>
        /// <param name="sessionStartOn"> Remote Support Session StartTime on the Node. </param>
        /// <param name="sessionEndOn"> Remote Support Session EndTime on the Node. </param>
        /// <param name="nodeName"> Name of the node. </param>
        /// <param name="duration"> Duration of Remote Support Enablement. </param>
        /// <param name="accessLevel"> Remote Support Access Level. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PerNodeRemoteSupportSession(DateTimeOffset? sessionStartOn, DateTimeOffset? sessionEndOn, string nodeName, long? duration, HciClusterAccessLevel? accessLevel, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SessionStartOn = sessionStartOn;
            SessionEndOn = sessionEndOn;
            NodeName = nodeName;
            Duration = duration;
            AccessLevel = accessLevel;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Remote Support Session StartTime on the Node. </summary>
        [WirePath("sessionStartTime")]
        public DateTimeOffset? SessionStartOn { get; }
        /// <summary> Remote Support Session EndTime on the Node. </summary>
        [WirePath("sessionEndTime")]
        public DateTimeOffset? SessionEndOn { get; }
        /// <summary> Name of the node. </summary>
        [WirePath("nodeName")]
        public string NodeName { get; }
        /// <summary> Duration of Remote Support Enablement. </summary>
        [WirePath("duration")]
        public long? Duration { get; }
        /// <summary> Remote Support Access Level. </summary>
        [WirePath("accessLevel")]
        public HciClusterAccessLevel? AccessLevel { get; }
    }
}
