// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Hci.Models
{
    public partial class PerNodeRemoteSupportSession : IUtf8JsonSerializable, IJsonModel<PerNodeRemoteSupportSession>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<PerNodeRemoteSupportSession>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<PerNodeRemoteSupportSession>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PerNodeRemoteSupportSession>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PerNodeRemoteSupportSession)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(SessionStartOn))
            {
                writer.WritePropertyName("sessionStartTime"u8);
                writer.WriteStringValue(SessionStartOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(SessionEndOn))
            {
                writer.WritePropertyName("sessionEndTime"u8);
                writer.WriteStringValue(SessionEndOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(NodeName))
            {
                writer.WritePropertyName("nodeName"u8);
                writer.WriteStringValue(NodeName);
            }
            if (options.Format != "W" && Optional.IsDefined(Duration))
            {
                writer.WritePropertyName("duration"u8);
                writer.WriteNumberValue(Duration.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(AccessLevel))
            {
                writer.WritePropertyName("accessLevel"u8);
                writer.WriteStringValue(AccessLevel.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        PerNodeRemoteSupportSession IJsonModel<PerNodeRemoteSupportSession>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PerNodeRemoteSupportSession>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(PerNodeRemoteSupportSession)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializePerNodeRemoteSupportSession(document.RootElement, options);
        }

        internal static PerNodeRemoteSupportSession DeserializePerNodeRemoteSupportSession(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            DateTimeOffset? sessionStartTime = default;
            DateTimeOffset? sessionEndTime = default;
            string nodeName = default;
            long? duration = default;
            HciClusterAccessLevel? accessLevel = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("sessionStartTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sessionStartTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("sessionEndTime"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sessionEndTime = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("nodeName"u8))
                {
                    nodeName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("duration"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    duration = property.Value.GetInt64();
                    continue;
                }
                if (property.NameEquals("accessLevel"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    accessLevel = new HciClusterAccessLevel(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new PerNodeRemoteSupportSession(
                sessionStartTime,
                sessionEndTime,
                nodeName,
                duration,
                accessLevel,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SessionStartOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  sessionStartTime: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SessionStartOn))
                {
                    builder.Append("  sessionStartTime: ");
                    var formattedDateTimeString = TypeFormatters.ToString(SessionStartOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SessionEndOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  sessionEndTime: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(SessionEndOn))
                {
                    builder.Append("  sessionEndTime: ");
                    var formattedDateTimeString = TypeFormatters.ToString(SessionEndOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(NodeName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  nodeName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(NodeName))
                {
                    builder.Append("  nodeName: ");
                    if (NodeName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{NodeName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{NodeName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Duration), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  duration: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Duration))
                {
                    builder.Append("  duration: ");
                    builder.AppendLine($"'{Duration.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AccessLevel), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  accessLevel: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AccessLevel))
                {
                    builder.Append("  accessLevel: ");
                    builder.AppendLine($"'{AccessLevel.Value.ToString()}'");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<PerNodeRemoteSupportSession>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PerNodeRemoteSupportSession>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(PerNodeRemoteSupportSession)} does not support writing '{options.Format}' format.");
            }
        }

        PerNodeRemoteSupportSession IPersistableModel<PerNodeRemoteSupportSession>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<PerNodeRemoteSupportSession>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializePerNodeRemoteSupportSession(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(PerNodeRemoteSupportSession)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<PerNodeRemoteSupportSession>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
