// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> Status of Arc Extension for a particular node in HCI Cluster. </summary>
    public partial class PerNodeExtensionState
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PerNodeExtensionState"/>. </summary>
        internal PerNodeExtensionState()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PerNodeExtensionState"/>. </summary>
        /// <param name="name"> Name of the node in HCI Cluster. </param>
        /// <param name="extension"> Fully qualified resource ID for the particular Arc Extension on this node. </param>
        /// <param name="typeHandlerVersion"> Specifies the version of the script handler. </param>
        /// <param name="state"> State of Arc Extension in this node. </param>
        /// <param name="extensionInstanceView"> The extension instance view. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PerNodeExtensionState(string name, string extension, string typeHandlerVersion, NodeExtensionState? state, ArcExtensionInstanceView extensionInstanceView, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Extension = extension;
            TypeHandlerVersion = typeHandlerVersion;
            State = state;
            ExtensionInstanceView = extensionInstanceView;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the node in HCI Cluster. </summary>
        [WirePath("name")]
        public string Name { get; }
        /// <summary> Fully qualified resource ID for the particular Arc Extension on this node. </summary>
        [WirePath("extension")]
        public string Extension { get; }
        /// <summary> Specifies the version of the script handler. </summary>
        [WirePath("typeHandlerVersion")]
        public string TypeHandlerVersion { get; }
        /// <summary> State of Arc Extension in this node. </summary>
        [WirePath("state")]
        public NodeExtensionState? State { get; }
        /// <summary> The extension instance view. </summary>
        [WirePath("instanceView")]
        public ArcExtensionInstanceView ExtensionInstanceView { get; }
    }
}
