// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> Status of Arc agent for a particular node in HCI Cluster. </summary>
    public partial class PerNodeArcState
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="PerNodeArcState"/>. </summary>
        internal PerNodeArcState()
        {
        }

        /// <summary> Initializes a new instance of <see cref="PerNodeArcState"/>. </summary>
        /// <param name="name"> Name of the Node in HCI Cluster. </param>
        /// <param name="arcInstance"> Fully qualified resource ID for the Arc agent of this node. </param>
        /// <param name="arcNodeServicePrincipalObjectId"> The service principal id of the arc for server node. </param>
        /// <param name="state"> State of Arc agent in this node. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal PerNodeArcState(string name, string arcInstance, Guid? arcNodeServicePrincipalObjectId, NodeArcState? state, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            ArcInstance = arcInstance;
            ArcNodeServicePrincipalObjectId = arcNodeServicePrincipalObjectId;
            State = state;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the Node in HCI Cluster. </summary>
        [WirePath("name")]
        public string Name { get; }
        /// <summary> Fully qualified resource ID for the Arc agent of this node. </summary>
        [WirePath("arcInstance")]
        public string ArcInstance { get; }
        /// <summary> The service principal id of the arc for server node. </summary>
        [WirePath("arcNodeServicePrincipalObjectId")]
        public Guid? ArcNodeServicePrincipalObjectId { get; }
        /// <summary> State of Arc agent in this node. </summary>
        [WirePath("state")]
        public NodeArcState? State { get; }
    }
}
