// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> OEM activation status of the cluster. </summary>
    public readonly partial struct OemActivation : IEquatable<OemActivation>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="OemActivation"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public OemActivation(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisabledValue = "Disabled";
        private const string EnabledValue = "Enabled";

        /// <summary> Disabled. </summary>
        public static OemActivation Disabled { get; } = new OemActivation(DisabledValue);
        /// <summary> Enabled. </summary>
        public static OemActivation Enabled { get; } = new OemActivation(EnabledValue);
        /// <summary> Determines if two <see cref="OemActivation"/> values are the same. </summary>
        public static bool operator ==(OemActivation left, OemActivation right) => left.Equals(right);
        /// <summary> Determines if two <see cref="OemActivation"/> values are not the same. </summary>
        public static bool operator !=(OemActivation left, OemActivation right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="OemActivation"/>. </summary>
        public static implicit operator OemActivation(string value) => new OemActivation(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is OemActivation other && Equals(other);
        /// <inheritdoc />
        public bool Equals(OemActivation other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
