// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> State of Arc Extension in this node. </summary>
    public readonly partial struct NodeExtensionState : IEquatable<NodeExtensionState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NodeExtensionState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NodeExtensionState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string ErrorValue = "Error";
        private const string SucceededValue = "Succeeded";
        private const string CanceledValue = "Canceled";
        private const string FailedValue = "Failed";
        private const string ConnectedValue = "Connected";
        private const string DisconnectedValue = "Disconnected";
        private const string DeletedValue = "Deleted";
        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string MovingValue = "Moving";
        private const string PartiallySucceededValue = "PartiallySucceeded";
        private const string PartiallyConnectedValue = "PartiallyConnected";
        private const string InProgressValue = "InProgress";
        private const string AcceptedValue = "Accepted";
        private const string ProvisioningValue = "Provisioning";

        /// <summary> NotSpecified. </summary>
        public static NodeExtensionState NotSpecified { get; } = new NodeExtensionState(NotSpecifiedValue);
        /// <summary> Error. </summary>
        public static NodeExtensionState Error { get; } = new NodeExtensionState(ErrorValue);
        /// <summary> Succeeded. </summary>
        public static NodeExtensionState Succeeded { get; } = new NodeExtensionState(SucceededValue);
        /// <summary> Canceled. </summary>
        public static NodeExtensionState Canceled { get; } = new NodeExtensionState(CanceledValue);
        /// <summary> Failed. </summary>
        public static NodeExtensionState Failed { get; } = new NodeExtensionState(FailedValue);
        /// <summary> Connected. </summary>
        public static NodeExtensionState Connected { get; } = new NodeExtensionState(ConnectedValue);
        /// <summary> Disconnected. </summary>
        public static NodeExtensionState Disconnected { get; } = new NodeExtensionState(DisconnectedValue);
        /// <summary> Deleted. </summary>
        public static NodeExtensionState Deleted { get; } = new NodeExtensionState(DeletedValue);
        /// <summary> Creating. </summary>
        public static NodeExtensionState Creating { get; } = new NodeExtensionState(CreatingValue);
        /// <summary> Updating. </summary>
        public static NodeExtensionState Updating { get; } = new NodeExtensionState(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static NodeExtensionState Deleting { get; } = new NodeExtensionState(DeletingValue);
        /// <summary> Moving. </summary>
        public static NodeExtensionState Moving { get; } = new NodeExtensionState(MovingValue);
        /// <summary> PartiallySucceeded. </summary>
        public static NodeExtensionState PartiallySucceeded { get; } = new NodeExtensionState(PartiallySucceededValue);
        /// <summary> PartiallyConnected. </summary>
        public static NodeExtensionState PartiallyConnected { get; } = new NodeExtensionState(PartiallyConnectedValue);
        /// <summary> InProgress. </summary>
        public static NodeExtensionState InProgress { get; } = new NodeExtensionState(InProgressValue);
        /// <summary> Accepted. </summary>
        public static NodeExtensionState Accepted { get; } = new NodeExtensionState(AcceptedValue);
        /// <summary> Provisioning. </summary>
        public static NodeExtensionState Provisioning { get; } = new NodeExtensionState(ProvisioningValue);
        /// <summary> Determines if two <see cref="NodeExtensionState"/> values are the same. </summary>
        public static bool operator ==(NodeExtensionState left, NodeExtensionState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NodeExtensionState"/> values are not the same. </summary>
        public static bool operator !=(NodeExtensionState left, NodeExtensionState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NodeExtensionState"/>. </summary>
        public static implicit operator NodeExtensionState(string value) => new NodeExtensionState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NodeExtensionState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NodeExtensionState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
