// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> State of Arc agent in this node. </summary>
    public readonly partial struct NodeArcState : IEquatable<NodeArcState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="NodeArcState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public NodeArcState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string ErrorValue = "Error";
        private const string SucceededValue = "Succeeded";
        private const string CanceledValue = "Canceled";
        private const string FailedValue = "Failed";
        private const string ConnectedValue = "Connected";
        private const string DisconnectedValue = "Disconnected";
        private const string DeletedValue = "Deleted";
        private const string CreatingValue = "Creating";
        private const string UpdatingValue = "Updating";
        private const string DeletingValue = "Deleting";
        private const string MovingValue = "Moving";
        private const string PartiallySucceededValue = "PartiallySucceeded";
        private const string PartiallyConnectedValue = "PartiallyConnected";
        private const string InProgressValue = "InProgress";
        private const string AcceptedValue = "Accepted";
        private const string ProvisioningValue = "Provisioning";
        private const string DisableInProgressValue = "DisableInProgress";

        /// <summary> NotSpecified. </summary>
        public static NodeArcState NotSpecified { get; } = new NodeArcState(NotSpecifiedValue);
        /// <summary> Error. </summary>
        public static NodeArcState Error { get; } = new NodeArcState(ErrorValue);
        /// <summary> Succeeded. </summary>
        public static NodeArcState Succeeded { get; } = new NodeArcState(SucceededValue);
        /// <summary> Canceled. </summary>
        public static NodeArcState Canceled { get; } = new NodeArcState(CanceledValue);
        /// <summary> Failed. </summary>
        public static NodeArcState Failed { get; } = new NodeArcState(FailedValue);
        /// <summary> Connected. </summary>
        public static NodeArcState Connected { get; } = new NodeArcState(ConnectedValue);
        /// <summary> Disconnected. </summary>
        public static NodeArcState Disconnected { get; } = new NodeArcState(DisconnectedValue);
        /// <summary> Deleted. </summary>
        public static NodeArcState Deleted { get; } = new NodeArcState(DeletedValue);
        /// <summary> Creating. </summary>
        public static NodeArcState Creating { get; } = new NodeArcState(CreatingValue);
        /// <summary> Updating. </summary>
        public static NodeArcState Updating { get; } = new NodeArcState(UpdatingValue);
        /// <summary> Deleting. </summary>
        public static NodeArcState Deleting { get; } = new NodeArcState(DeletingValue);
        /// <summary> Moving. </summary>
        public static NodeArcState Moving { get; } = new NodeArcState(MovingValue);
        /// <summary> PartiallySucceeded. </summary>
        public static NodeArcState PartiallySucceeded { get; } = new NodeArcState(PartiallySucceededValue);
        /// <summary> PartiallyConnected. </summary>
        public static NodeArcState PartiallyConnected { get; } = new NodeArcState(PartiallyConnectedValue);
        /// <summary> InProgress. </summary>
        public static NodeArcState InProgress { get; } = new NodeArcState(InProgressValue);
        /// <summary> Accepted. </summary>
        public static NodeArcState Accepted { get; } = new NodeArcState(AcceptedValue);
        /// <summary> Provisioning. </summary>
        public static NodeArcState Provisioning { get; } = new NodeArcState(ProvisioningValue);
        /// <summary> DisableInProgress. </summary>
        public static NodeArcState DisableInProgress { get; } = new NodeArcState(DisableInProgressValue);
        /// <summary> Determines if two <see cref="NodeArcState"/> values are the same. </summary>
        public static bool operator ==(NodeArcState left, NodeArcState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="NodeArcState"/> values are not the same. </summary>
        public static bool operator !=(NodeArcState left, NodeArcState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="NodeArcState"/>. </summary>
        public static implicit operator NodeArcState(string value) => new NodeArcState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is NodeArcState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(NodeArcState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
