// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> LogCollection status. </summary>
    public readonly partial struct LogCollectionStatus : IEquatable<LogCollectionStatus>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LogCollectionStatus"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LogCollectionStatus(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NoneValue = "None";
        private const string InProgressValue = "InProgress";
        private const string FailedValue = "Failed";
        private const string SucceededValue = "Succeeded";

        /// <summary> None. </summary>
        public static LogCollectionStatus None { get; } = new LogCollectionStatus(NoneValue);
        /// <summary> InProgress. </summary>
        public static LogCollectionStatus InProgress { get; } = new LogCollectionStatus(InProgressValue);
        /// <summary> Failed. </summary>
        public static LogCollectionStatus Failed { get; } = new LogCollectionStatus(FailedValue);
        /// <summary> Succeeded. </summary>
        public static LogCollectionStatus Succeeded { get; } = new LogCollectionStatus(SucceededValue);
        /// <summary> Determines if two <see cref="LogCollectionStatus"/> values are the same. </summary>
        public static bool operator ==(LogCollectionStatus left, LogCollectionStatus right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LogCollectionStatus"/> values are not the same. </summary>
        public static bool operator !=(LogCollectionStatus left, LogCollectionStatus right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LogCollectionStatus"/>. </summary>
        public static implicit operator LogCollectionStatus(string value) => new LogCollectionStatus(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LogCollectionStatus other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LogCollectionStatus other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
