// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> Log Collection properties of the cluster. </summary>
    public partial class LogCollectionProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LogCollectionProperties"/>. </summary>
        public LogCollectionProperties()
        {
            LogCollectionSessionDetails = new ChangeTrackingList<LogCollectionSession>();
        }

        /// <summary> Initializes a new instance of <see cref="LogCollectionProperties"/>. </summary>
        /// <param name="fromDate"> From DateTimeStamp from when logs need to be connected. </param>
        /// <param name="toDate"> To DateTimeStamp till when logs need to be connected. </param>
        /// <param name="lastLogGenerated"> Recent DateTimeStamp where logs are successfully generated. </param>
        /// <param name="logCollectionSessionDetails"></param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LogCollectionProperties(DateTimeOffset? fromDate, DateTimeOffset? toDate, DateTimeOffset? lastLogGenerated, IReadOnlyList<LogCollectionSession> logCollectionSessionDetails, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FromDate = fromDate;
            ToDate = toDate;
            LastLogGenerated = lastLogGenerated;
            LogCollectionSessionDetails = logCollectionSessionDetails;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> From DateTimeStamp from when logs need to be connected. </summary>
        [WirePath("fromDate")]
        public DateTimeOffset? FromDate { get; }
        /// <summary> To DateTimeStamp till when logs need to be connected. </summary>
        [WirePath("toDate")]
        public DateTimeOffset? ToDate { get; }
        /// <summary> Recent DateTimeStamp where logs are successfully generated. </summary>
        [WirePath("lastLogGenerated")]
        public DateTimeOffset? LastLogGenerated { get; }
        /// <summary> Gets the log collection session details. </summary>
        [WirePath("logCollectionSessionDetails")]
        public IReadOnlyList<LogCollectionSession> LogCollectionSessionDetails { get; }
    }
}
