// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Hci.Models
{
    public partial class LogCollectionProperties : IUtf8JsonSerializable, IJsonModel<LogCollectionProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<LogCollectionProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<LogCollectionProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LogCollectionProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(LogCollectionProperties)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(FromDate))
            {
                writer.WritePropertyName("fromDate"u8);
                writer.WriteStringValue(FromDate.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(ToDate))
            {
                writer.WritePropertyName("toDate"u8);
                writer.WriteStringValue(ToDate.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(LastLogGenerated))
            {
                writer.WritePropertyName("lastLogGenerated"u8);
                writer.WriteStringValue(LastLogGenerated.Value, "O");
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(LogCollectionSessionDetails))
            {
                writer.WritePropertyName("logCollectionSessionDetails"u8);
                writer.WriteStartArray();
                foreach (var item in LogCollectionSessionDetails)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        LogCollectionProperties IJsonModel<LogCollectionProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LogCollectionProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(LogCollectionProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeLogCollectionProperties(document.RootElement, options);
        }

        internal static LogCollectionProperties DeserializeLogCollectionProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            DateTimeOffset? fromDate = default;
            DateTimeOffset? toDate = default;
            DateTimeOffset? lastLogGenerated = default;
            IReadOnlyList<LogCollectionSession> logCollectionSessionDetails = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("fromDate"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    fromDate = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("toDate"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    toDate = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("lastLogGenerated"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastLogGenerated = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("logCollectionSessionDetails"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<LogCollectionSession> array = new List<LogCollectionSession>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(LogCollectionSession.DeserializeLogCollectionSession(item, options));
                    }
                    logCollectionSessionDetails = array;
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new LogCollectionProperties(fromDate, toDate, lastLogGenerated, logCollectionSessionDetails ?? new ChangeTrackingList<LogCollectionSession>(), serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(FromDate), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  fromDate: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(FromDate))
                {
                    builder.Append("  fromDate: ");
                    var formattedDateTimeString = TypeFormatters.ToString(FromDate.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ToDate), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  toDate: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ToDate))
                {
                    builder.Append("  toDate: ");
                    var formattedDateTimeString = TypeFormatters.ToString(ToDate.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LastLogGenerated), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  lastLogGenerated: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LastLogGenerated))
                {
                    builder.Append("  lastLogGenerated: ");
                    var formattedDateTimeString = TypeFormatters.ToString(LastLogGenerated.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LogCollectionSessionDetails), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  logCollectionSessionDetails: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(LogCollectionSessionDetails))
                {
                    if (LogCollectionSessionDetails.Any())
                    {
                        builder.Append("  logCollectionSessionDetails: ");
                        builder.AppendLine("[");
                        foreach (var item in LogCollectionSessionDetails)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  logCollectionSessionDetails: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<LogCollectionProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LogCollectionProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(LogCollectionProperties)} does not support writing '{options.Format}' format.");
            }
        }

        LogCollectionProperties IPersistableModel<LogCollectionProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<LogCollectionProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeLogCollectionProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(LogCollectionProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<LogCollectionProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
