// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> LogCollection job type. </summary>
    public readonly partial struct LogCollectionJobType : IEquatable<LogCollectionJobType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="LogCollectionJobType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public LogCollectionJobType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string OnDemandValue = "OnDemand";
        private const string ScheduledValue = "Scheduled";

        /// <summary> OnDemand. </summary>
        public static LogCollectionJobType OnDemand { get; } = new LogCollectionJobType(OnDemandValue);
        /// <summary> Scheduled. </summary>
        public static LogCollectionJobType Scheduled { get; } = new LogCollectionJobType(ScheduledValue);
        /// <summary> Determines if two <see cref="LogCollectionJobType"/> values are the same. </summary>
        public static bool operator ==(LogCollectionJobType left, LogCollectionJobType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="LogCollectionJobType"/> values are not the same. </summary>
        public static bool operator !=(LogCollectionJobType left, LogCollectionJobType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="LogCollectionJobType"/>. </summary>
        public static implicit operator LogCollectionJobType(string value) => new LogCollectionJobType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is LogCollectionJobType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(LogCollectionJobType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
