// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> Properties for Log Collection Request. </summary>
    public partial class LogCollectionContentProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="LogCollectionContentProperties"/>. </summary>
        /// <param name="fromDate"> From DateTimeStamp from when logs need to be connected. </param>
        /// <param name="toDate"> To DateTimeStamp till when logs need to be connected. </param>
        public LogCollectionContentProperties(DateTimeOffset fromDate, DateTimeOffset toDate)
        {
            FromDate = fromDate;
            ToDate = toDate;
        }

        /// <summary> Initializes a new instance of <see cref="LogCollectionContentProperties"/>. </summary>
        /// <param name="fromDate"> From DateTimeStamp from when logs need to be connected. </param>
        /// <param name="toDate"> To DateTimeStamp till when logs need to be connected. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal LogCollectionContentProperties(DateTimeOffset fromDate, DateTimeOffset toDate, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            FromDate = fromDate;
            ToDate = toDate;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="LogCollectionContentProperties"/> for deserialization. </summary>
        internal LogCollectionContentProperties()
        {
        }

        /// <summary> From DateTimeStamp from when logs need to be connected. </summary>
        [WirePath("fromDate")]
        public DateTimeOffset FromDate { get; }
        /// <summary> To DateTimeStamp till when logs need to be connected. </summary>
        [WirePath("toDate")]
        public DateTimeOffset ToDate { get; }
    }
}
