// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using Azure.Core;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> Attestation configurations for isolated VM (e.g. TVM, CVM) of the cluster. </summary>
    public partial class IsolatedVmAttestationConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="IsolatedVmAttestationConfiguration"/>. </summary>
        internal IsolatedVmAttestationConfiguration()
        {
        }

        /// <summary> Initializes a new instance of <see cref="IsolatedVmAttestationConfiguration"/>. </summary>
        /// <param name="attestationResourceId"> Fully qualified Azure resource id of the Microsoft Azure attestation resource associated with this cluster. </param>
        /// <param name="relyingPartyServiceEndpoint"> Region specific endpoint for relying party service. </param>
        /// <param name="attestationServiceEndpoint"> Region specific endpoint for Microsoft Azure Attestation service for the cluster. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal IsolatedVmAttestationConfiguration(ResourceIdentifier attestationResourceId, string relyingPartyServiceEndpoint, string attestationServiceEndpoint, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AttestationResourceId = attestationResourceId;
            RelyingPartyServiceEndpoint = relyingPartyServiceEndpoint;
            AttestationServiceEndpoint = attestationServiceEndpoint;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Fully qualified Azure resource id of the Microsoft Azure attestation resource associated with this cluster. </summary>
        [WirePath("attestationResourceId")]
        public ResourceIdentifier AttestationResourceId { get; }
        /// <summary> Region specific endpoint for relying party service. </summary>
        [WirePath("relyingPartyServiceEndpoint")]
        public string RelyingPartyServiceEndpoint { get; }
        /// <summary> Region specific endpoint for Microsoft Azure Attestation service for the cluster. </summary>
        [WirePath("attestationServiceEndpoint")]
        public string AttestationServiceEndpoint { get; }
    }
}
