// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Hci.Models
{
    public partial class IsolatedVmAttestationConfiguration : IUtf8JsonSerializable, IJsonModel<IsolatedVmAttestationConfiguration>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<IsolatedVmAttestationConfiguration>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<IsolatedVmAttestationConfiguration>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IsolatedVmAttestationConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(IsolatedVmAttestationConfiguration)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(AttestationResourceId))
            {
                writer.WritePropertyName("attestationResourceId"u8);
                writer.WriteStringValue(AttestationResourceId);
            }
            if (options.Format != "W" && Optional.IsDefined(RelyingPartyServiceEndpoint))
            {
                writer.WritePropertyName("relyingPartyServiceEndpoint"u8);
                writer.WriteStringValue(RelyingPartyServiceEndpoint);
            }
            if (options.Format != "W" && Optional.IsDefined(AttestationServiceEndpoint))
            {
                writer.WritePropertyName("attestationServiceEndpoint"u8);
                writer.WriteStringValue(AttestationServiceEndpoint);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        IsolatedVmAttestationConfiguration IJsonModel<IsolatedVmAttestationConfiguration>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IsolatedVmAttestationConfiguration>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(IsolatedVmAttestationConfiguration)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeIsolatedVmAttestationConfiguration(document.RootElement, options);
        }

        internal static IsolatedVmAttestationConfiguration DeserializeIsolatedVmAttestationConfiguration(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            ResourceIdentifier attestationResourceId = default;
            string relyingPartyServiceEndpoint = default;
            string attestationServiceEndpoint = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("attestationResourceId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    attestationResourceId = new ResourceIdentifier(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("relyingPartyServiceEndpoint"u8))
                {
                    relyingPartyServiceEndpoint = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("attestationServiceEndpoint"u8))
                {
                    attestationServiceEndpoint = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new IsolatedVmAttestationConfiguration(attestationResourceId, relyingPartyServiceEndpoint, attestationServiceEndpoint, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AttestationResourceId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  attestationResourceId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AttestationResourceId))
                {
                    builder.Append("  attestationResourceId: ");
                    builder.AppendLine($"'{AttestationResourceId.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(RelyingPartyServiceEndpoint), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  relyingPartyServiceEndpoint: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(RelyingPartyServiceEndpoint))
                {
                    builder.Append("  relyingPartyServiceEndpoint: ");
                    if (RelyingPartyServiceEndpoint.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{RelyingPartyServiceEndpoint}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{RelyingPartyServiceEndpoint}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AttestationServiceEndpoint), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  attestationServiceEndpoint: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AttestationServiceEndpoint))
                {
                    builder.Append("  attestationServiceEndpoint: ");
                    if (AttestationServiceEndpoint.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{AttestationServiceEndpoint}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{AttestationServiceEndpoint}'");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<IsolatedVmAttestationConfiguration>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IsolatedVmAttestationConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(IsolatedVmAttestationConfiguration)} does not support writing '{options.Format}' format.");
            }
        }

        IsolatedVmAttestationConfiguration IPersistableModel<IsolatedVmAttestationConfiguration>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<IsolatedVmAttestationConfiguration>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeIsolatedVmAttestationConfiguration(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(IsolatedVmAttestationConfiguration)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<IsolatedVmAttestationConfiguration>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
