// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> IMDS attestation status of the cluster. </summary>
    public readonly partial struct ImdsAttestationState : IEquatable<ImdsAttestationState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="ImdsAttestationState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public ImdsAttestationState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string DisabledValue = "Disabled";
        private const string EnabledValue = "Enabled";

        /// <summary> Disabled. </summary>
        public static ImdsAttestationState Disabled { get; } = new ImdsAttestationState(DisabledValue);
        /// <summary> Enabled. </summary>
        public static ImdsAttestationState Enabled { get; } = new ImdsAttestationState(EnabledValue);
        /// <summary> Determines if two <see cref="ImdsAttestationState"/> values are the same. </summary>
        public static bool operator ==(ImdsAttestationState left, ImdsAttestationState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="ImdsAttestationState"/> values are not the same. </summary>
        public static bool operator !=(ImdsAttestationState left, ImdsAttestationState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="ImdsAttestationState"/>. </summary>
        public static implicit operator ImdsAttestationState(string value) => new ImdsAttestationState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is ImdsAttestationState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(ImdsAttestationState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
