// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> Progress representation of the update run steps. </summary>
    public partial class HciUpdateStep
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HciUpdateStep"/>. </summary>
        public HciUpdateStep()
        {
            Steps = new ChangeTrackingList<HciUpdateStep>();
        }

        /// <summary> Initializes a new instance of <see cref="HciUpdateStep"/>. </summary>
        /// <param name="name"> Name of the step. </param>
        /// <param name="description"> More detailed description of the step. </param>
        /// <param name="errorMessage"> Error message, specified if the step is in a failed state. </param>
        /// <param name="status"> Status of the step, bubbled up from the ECE action plan for installation attempts. Values are: 'Success', 'Error', 'InProgress', and 'Unknown status'. </param>
        /// <param name="startOn"> When the step started, or empty if it has not started executing. </param>
        /// <param name="endOn"> When the step reached a terminal state. </param>
        /// <param name="lastUpdatedOn"> Completion time of this step or the last completed sub-step. </param>
        /// <param name="expectedExecutionTime"> Expected execution time of a given step. This is optionally authored in the update action plan and can be empty. </param>
        /// <param name="steps"> Recursive model for child steps of this step. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HciUpdateStep(string name, string description, string errorMessage, string status, DateTimeOffset? startOn, DateTimeOffset? endOn, DateTimeOffset? lastUpdatedOn, string expectedExecutionTime, IList<HciUpdateStep> steps, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Description = description;
            ErrorMessage = errorMessage;
            Status = status;
            StartOn = startOn;
            EndOn = endOn;
            LastUpdatedOn = lastUpdatedOn;
            ExpectedExecutionTime = expectedExecutionTime;
            Steps = steps;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the step. </summary>
        [WirePath("name")]
        public string Name { get; set; }
        /// <summary> More detailed description of the step. </summary>
        [WirePath("description")]
        public string Description { get; set; }
        /// <summary> Error message, specified if the step is in a failed state. </summary>
        [WirePath("errorMessage")]
        public string ErrorMessage { get; set; }
        /// <summary> Status of the step, bubbled up from the ECE action plan for installation attempts. Values are: 'Success', 'Error', 'InProgress', and 'Unknown status'. </summary>
        [WirePath("status")]
        public string Status { get; set; }
        /// <summary> When the step started, or empty if it has not started executing. </summary>
        [WirePath("startTimeUtc")]
        public DateTimeOffset? StartOn { get; set; }
        /// <summary> When the step reached a terminal state. </summary>
        [WirePath("endTimeUtc")]
        public DateTimeOffset? EndOn { get; set; }
        /// <summary> Completion time of this step or the last completed sub-step. </summary>
        [WirePath("lastUpdatedTimeUtc")]
        public DateTimeOffset? LastUpdatedOn { get; set; }
        /// <summary> Expected execution time of a given step. This is optionally authored in the update action plan and can be empty. </summary>
        [WirePath("expectedExecutionTime")]
        public string ExpectedExecutionTime { get; set; }
        /// <summary> Recursive model for child steps of this step. </summary>
        [WirePath("steps")]
        public IList<HciUpdateStep> Steps { get; }
    }
}
