// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> The level code. </summary>
    public readonly partial struct HciStatusLevelType : IEquatable<HciStatusLevelType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HciStatusLevelType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HciStatusLevelType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string InfoValue = "Info";
        private const string WarningValue = "Warning";
        private const string ErrorValue = "Error";

        /// <summary> Info. </summary>
        public static HciStatusLevelType Info { get; } = new HciStatusLevelType(InfoValue);
        /// <summary> Warning. </summary>
        public static HciStatusLevelType Warning { get; } = new HciStatusLevelType(WarningValue);
        /// <summary> Error. </summary>
        public static HciStatusLevelType Error { get; } = new HciStatusLevelType(ErrorValue);
        /// <summary> Determines if two <see cref="HciStatusLevelType"/> values are the same. </summary>
        public static bool operator ==(HciStatusLevelType left, HciStatusLevelType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HciStatusLevelType"/> values are not the same. </summary>
        public static bool operator !=(HciStatusLevelType left, HciStatusLevelType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HciStatusLevelType"/>. </summary>
        public static implicit operator HciStatusLevelType(string value) => new HciStatusLevelType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HciStatusLevelType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HciStatusLevelType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
