// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> SKU Mapping details. </summary>
    public partial class HciSkuMappings
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HciSkuMappings"/>. </summary>
        public HciSkuMappings()
        {
            MarketplaceSkuVersions = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="HciSkuMappings"/>. </summary>
        /// <param name="catalogPlanId"> Identifier of the CatalogPlan for the sku. </param>
        /// <param name="marketplaceSkuId"> Identifier for the sku. </param>
        /// <param name="marketplaceSkuVersions"> Array of SKU versions available. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HciSkuMappings(string catalogPlanId, string marketplaceSkuId, IList<string> marketplaceSkuVersions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            CatalogPlanId = catalogPlanId;
            MarketplaceSkuId = marketplaceSkuId;
            MarketplaceSkuVersions = marketplaceSkuVersions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Identifier of the CatalogPlan for the sku. </summary>
        [WirePath("catalogPlanId")]
        public string CatalogPlanId { get; set; }
        /// <summary> Identifier for the sku. </summary>
        [WirePath("marketplaceSkuId")]
        public string MarketplaceSkuId { get; set; }
        /// <summary> Array of SKU versions available. </summary>
        [WirePath("marketplaceSkuVersions")]
        public IList<string> MarketplaceSkuVersions { get; }
    }
}
