// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> OS configurations for HCI device. </summary>
    public partial class HciOSProfile
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HciOSProfile"/>. </summary>
        internal HciOSProfile()
        {
        }

        /// <summary> Initializes a new instance of <see cref="HciOSProfile"/>. </summary>
        /// <param name="bootType"> The boot type of the device. e.g. UEFI, Legacy etc. </param>
        /// <param name="assemblyVersion"> Version of assembly present on device. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HciOSProfile(string bootType, string assemblyVersion, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            BootType = bootType;
            AssemblyVersion = assemblyVersion;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The boot type of the device. e.g. UEFI, Legacy etc. </summary>
        [WirePath("bootType")]
        public string BootType { get; }
        /// <summary> Version of assembly present on device. </summary>
        [WirePath("assemblyVersion")]
        public string AssemblyVersion { get; }
    }
}
