// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Hci.Models
{
    public partial class HciEdgeDeviceVirtualSwitchConfigurationOverrides : IUtf8JsonSerializable, IJsonModel<HciEdgeDeviceVirtualSwitchConfigurationOverrides>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<HciEdgeDeviceVirtualSwitchConfigurationOverrides>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<HciEdgeDeviceVirtualSwitchConfigurationOverrides>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HciEdgeDeviceVirtualSwitchConfigurationOverrides>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HciEdgeDeviceVirtualSwitchConfigurationOverrides)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(EnableIov))
            {
                writer.WritePropertyName("enableIov"u8);
                writer.WriteStringValue(EnableIov);
            }
            if (options.Format != "W" && Optional.IsDefined(LoadBalancingAlgorithm))
            {
                writer.WritePropertyName("loadBalancingAlgorithm"u8);
                writer.WriteStringValue(LoadBalancingAlgorithm);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        HciEdgeDeviceVirtualSwitchConfigurationOverrides IJsonModel<HciEdgeDeviceVirtualSwitchConfigurationOverrides>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HciEdgeDeviceVirtualSwitchConfigurationOverrides>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HciEdgeDeviceVirtualSwitchConfigurationOverrides)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeHciEdgeDeviceVirtualSwitchConfigurationOverrides(document.RootElement, options);
        }

        internal static HciEdgeDeviceVirtualSwitchConfigurationOverrides DeserializeHciEdgeDeviceVirtualSwitchConfigurationOverrides(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string enableIov = default;
            string loadBalancingAlgorithm = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("enableIov"u8))
                {
                    enableIov = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("loadBalancingAlgorithm"u8))
                {
                    loadBalancingAlgorithm = property.Value.GetString();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new HciEdgeDeviceVirtualSwitchConfigurationOverrides(enableIov, loadBalancingAlgorithm, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EnableIov), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  enableIov: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EnableIov))
                {
                    builder.Append("  enableIov: ");
                    if (EnableIov.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{EnableIov}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{EnableIov}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LoadBalancingAlgorithm), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  loadBalancingAlgorithm: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LoadBalancingAlgorithm))
                {
                    builder.Append("  loadBalancingAlgorithm: ");
                    if (LoadBalancingAlgorithm.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{LoadBalancingAlgorithm}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{LoadBalancingAlgorithm}'");
                    }
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<HciEdgeDeviceVirtualSwitchConfigurationOverrides>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HciEdgeDeviceVirtualSwitchConfigurationOverrides>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(HciEdgeDeviceVirtualSwitchConfigurationOverrides)} does not support writing '{options.Format}' format.");
            }
        }

        HciEdgeDeviceVirtualSwitchConfigurationOverrides IPersistableModel<HciEdgeDeviceVirtualSwitchConfigurationOverrides>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HciEdgeDeviceVirtualSwitchConfigurationOverrides>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeHciEdgeDeviceVirtualSwitchConfigurationOverrides(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(HciEdgeDeviceVirtualSwitchConfigurationOverrides)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<HciEdgeDeviceVirtualSwitchConfigurationOverrides>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
