// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;
using System.Linq;
using Azure.Core;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> The validate request for Edge Device. </summary>
    public partial class HciEdgeDeviceValidateContent
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HciEdgeDeviceValidateContent"/>. </summary>
        /// <param name="edgeDeviceIds"> Node Ids against which, current node has to be validated. </param>
        /// <exception cref="ArgumentNullException"> <paramref name="edgeDeviceIds"/> is null. </exception>
        public HciEdgeDeviceValidateContent(IEnumerable<ResourceIdentifier> edgeDeviceIds)
        {
            Argument.AssertNotNull(edgeDeviceIds, nameof(edgeDeviceIds));

            EdgeDeviceIds = edgeDeviceIds.ToList();
        }

        /// <summary> Initializes a new instance of <see cref="HciEdgeDeviceValidateContent"/>. </summary>
        /// <param name="edgeDeviceIds"> Node Ids against which, current node has to be validated. </param>
        /// <param name="additionalInfo"> Additional info required for validation. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HciEdgeDeviceValidateContent(IList<ResourceIdentifier> edgeDeviceIds, string additionalInfo, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            EdgeDeviceIds = edgeDeviceIds;
            AdditionalInfo = additionalInfo;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Initializes a new instance of <see cref="HciEdgeDeviceValidateContent"/> for deserialization. </summary>
        internal HciEdgeDeviceValidateContent()
        {
        }

        /// <summary> Node Ids against which, current node has to be validated. </summary>
        [WirePath("edgeDeviceIds")]
        public IList<ResourceIdentifier> EdgeDeviceIds { get; }
        /// <summary> Additional info required for validation. </summary>
        [WirePath("additionalInfo")]
        public string AdditionalInfo { get; set; }
    }
}
