// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> List of switch details for edge device. </summary>
    public partial class HciEdgeDeviceSwitchDetail
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HciEdgeDeviceSwitchDetail"/>. </summary>
        internal HciEdgeDeviceSwitchDetail()
        {
            Extensions = new ChangeTrackingList<HciEdgeSwitchExtension>();
        }

        /// <summary> Initializes a new instance of <see cref="HciEdgeDeviceSwitchDetail"/>. </summary>
        /// <param name="switchName"> The name of the switch. </param>
        /// <param name="switchType"> The type of the switch. e.g. external, internal. </param>
        /// <param name="extensions"> This represents extensions installed on virtualSwitch. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HciEdgeDeviceSwitchDetail(string switchName, string switchType, IReadOnlyList<HciEdgeSwitchExtension> extensions, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SwitchName = switchName;
            SwitchType = switchType;
            Extensions = extensions;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The name of the switch. </summary>
        [WirePath("switchName")]
        public string SwitchName { get; }
        /// <summary> The type of the switch. e.g. external, internal. </summary>
        [WirePath("switchType")]
        public string SwitchType { get; }
        /// <summary> This represents extensions installed on virtualSwitch. </summary>
        [WirePath("extensions")]
        public IReadOnlyList<HciEdgeSwitchExtension> Extensions { get; }
    }
}
