// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> The StorageNetworks of a cluster. </summary>
    public partial class HciEdgeDeviceStorageNetworks
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HciEdgeDeviceStorageNetworks"/>. </summary>
        internal HciEdgeDeviceStorageNetworks()
        {
            StorageAdapterIPInfo = new ChangeTrackingList<HciEdgeDeviceStorageAdapterIPInfo>();
        }

        /// <summary> Initializes a new instance of <see cref="HciEdgeDeviceStorageNetworks"/>. </summary>
        /// <param name="name"> Name of the storage network. </param>
        /// <param name="networkAdapterName"> Name of the storage network adapter. </param>
        /// <param name="storageVlanId"> ID specified for the VLAN storage network. This setting is applied to the network interfaces that route the storage and VM migration traffic. </param>
        /// <param name="storageAdapterIPInfo"> List of Storage adapter physical nodes config to deploy AzureStackHCI Cluster. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HciEdgeDeviceStorageNetworks(string name, string networkAdapterName, string storageVlanId, IReadOnlyList<HciEdgeDeviceStorageAdapterIPInfo> storageAdapterIPInfo, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            NetworkAdapterName = networkAdapterName;
            StorageVlanId = storageVlanId;
            StorageAdapterIPInfo = storageAdapterIPInfo;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the storage network. </summary>
        [WirePath("name")]
        public string Name { get; }
        /// <summary> Name of the storage network adapter. </summary>
        [WirePath("networkAdapterName")]
        public string NetworkAdapterName { get; }
        /// <summary> ID specified for the VLAN storage network. This setting is applied to the network interfaces that route the storage and VM migration traffic. </summary>
        [WirePath("storageVlanId")]
        public string StorageVlanId { get; }
        /// <summary> List of Storage adapter physical nodes config to deploy AzureStackHCI Cluster. </summary>
        [WirePath("storageAdapterIPInfo")]
        public IReadOnlyList<HciEdgeDeviceStorageAdapterIPInfo> StorageAdapterIPInfo { get; }
    }
}
