// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> The StorageAdapter physical nodes of a cluster. </summary>
    public partial class HciEdgeDeviceStorageAdapterIPInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HciEdgeDeviceStorageAdapterIPInfo"/>. </summary>
        internal HciEdgeDeviceStorageAdapterIPInfo()
        {
        }

        /// <summary> Initializes a new instance of <see cref="HciEdgeDeviceStorageAdapterIPInfo"/>. </summary>
        /// <param name="physicalNode"> storage adapter physical node name. </param>
        /// <param name="ipv4Address"> The IPv4 address assigned to each storage adapter physical node on your Azure Stack HCI cluster. </param>
        /// <param name="subnetMask"> The SubnetMask address assigned to each storage adapter physical node on your Azure Stack HCI cluster. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HciEdgeDeviceStorageAdapterIPInfo(string physicalNode, string ipv4Address, string subnetMask, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            PhysicalNode = physicalNode;
            IPv4Address = ipv4Address;
            SubnetMask = subnetMask;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> storage adapter physical node name. </summary>
        [WirePath("physicalNode")]
        public string PhysicalNode { get; }
        /// <summary> The IPv4 address assigned to each storage adapter physical node on your Azure Stack HCI cluster. </summary>
        [WirePath("ipv4Address")]
        public string IPv4Address { get; }
        /// <summary> The SubnetMask address assigned to each storage adapter physical node on your Azure Stack HCI cluster. </summary>
        [WirePath("subnetMask")]
        public string SubnetMask { get; }
    }
}
