// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> The edge device state. </summary>
    public readonly partial struct HciEdgeDeviceState : IEquatable<HciEdgeDeviceState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HciEdgeDeviceState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HciEdgeDeviceState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string NotSpecifiedValue = "NotSpecified";
        private const string ConnectedValue = "Connected";
        private const string DisconnectedValue = "Disconnected";
        private const string RepairingValue = "Repairing";
        private const string DrainingValue = "Draining";
        private const string InMaintenanceValue = "InMaintenance";
        private const string ResumingValue = "Resuming";
        private const string ProcessingValue = "Processing";

        /// <summary> The edge device state is not specified. </summary>
        public static HciEdgeDeviceState NotSpecified { get; } = new HciEdgeDeviceState(NotSpecifiedValue);
        /// <summary> The edge device state is in connected state. </summary>
        public static HciEdgeDeviceState Connected { get; } = new HciEdgeDeviceState(ConnectedValue);
        /// <summary> The edge device state is in disconnected state. </summary>
        public static HciEdgeDeviceState Disconnected { get; } = new HciEdgeDeviceState(DisconnectedValue);
        /// <summary> The edge device state is in repairing state. </summary>
        public static HciEdgeDeviceState Repairing { get; } = new HciEdgeDeviceState(RepairingValue);
        /// <summary> The edge device state is in draining state. </summary>
        public static HciEdgeDeviceState Draining { get; } = new HciEdgeDeviceState(DrainingValue);
        /// <summary> The edge device state is in maintenance state. </summary>
        public static HciEdgeDeviceState InMaintenance { get; } = new HciEdgeDeviceState(InMaintenanceValue);
        /// <summary> The edge device state is in resuming state. </summary>
        public static HciEdgeDeviceState Resuming { get; } = new HciEdgeDeviceState(ResumingValue);
        /// <summary> The edge device state is in processing state. </summary>
        public static HciEdgeDeviceState Processing { get; } = new HciEdgeDeviceState(ProcessingValue);
        /// <summary> Determines if two <see cref="HciEdgeDeviceState"/> values are the same. </summary>
        public static bool operator ==(HciEdgeDeviceState left, HciEdgeDeviceState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HciEdgeDeviceState"/> values are not the same. </summary>
        public static bool operator !=(HciEdgeDeviceState left, HciEdgeDeviceState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HciEdgeDeviceState"/>. </summary>
        public static implicit operator HciEdgeDeviceState(string value) => new HciEdgeDeviceState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HciEdgeDeviceState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HciEdgeDeviceState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
