// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> Reported properties pushed from edge device. </summary>
    public partial class HciEdgeDeviceReportedProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private protected IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HciEdgeDeviceReportedProperties"/>. </summary>
        internal HciEdgeDeviceReportedProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="HciEdgeDeviceReportedProperties"/>. </summary>
        /// <param name="deviceState"> edge device state. </param>
        /// <param name="extensionProfile"> Extensions details for edge device. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HciEdgeDeviceReportedProperties(HciEdgeDeviceState? deviceState, HciEdgeDeviceExtensionProfile extensionProfile, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            DeviceState = deviceState;
            ExtensionProfile = extensionProfile;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> edge device state. </summary>
        [WirePath("deviceState")]
        public HciEdgeDeviceState? DeviceState { get; }
        /// <summary> Extensions details for edge device. </summary>
        internal HciEdgeDeviceExtensionProfile ExtensionProfile { get; }
        /// <summary> List of Arc extensions installed on edge device. </summary>
        [WirePath("extensionProfile.extensions")]
        public IReadOnlyList<HciEdgeDeviceArcExtension> Extensions
        {
            get => ExtensionProfile?.Extensions;
        }
    }
}
