// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> The NIC Detail of a device. </summary>
    public partial class HciEdgeDeviceNicDetail
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HciEdgeDeviceNicDetail"/>. </summary>
        public HciEdgeDeviceNicDetail()
        {
            DnsServers = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="HciEdgeDeviceNicDetail"/>. </summary>
        /// <param name="adapterName"> Adapter Name of NIC. </param>
        /// <param name="interfaceDescription"> Interface Description of NIC. </param>
        /// <param name="componentId"> Component Id of NIC. </param>
        /// <param name="driverVersion"> Driver Version of NIC. </param>
        /// <param name="ipv4Address"> Subnet Mask of NIC. </param>
        /// <param name="subnetMask"> Subnet Mask of NIC. </param>
        /// <param name="defaultGateway"> Default Gateway of NIC. </param>
        /// <param name="dnsServers"> DNS Servers for NIC. </param>
        /// <param name="defaultIsolationId"> Default Isolation of Management NIC. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HciEdgeDeviceNicDetail(string adapterName, string interfaceDescription, string componentId, string driverVersion, string ipv4Address, string subnetMask, string defaultGateway, IList<string> dnsServers, string defaultIsolationId, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            AdapterName = adapterName;
            InterfaceDescription = interfaceDescription;
            ComponentId = componentId;
            DriverVersion = driverVersion;
            IPv4Address = ipv4Address;
            SubnetMask = subnetMask;
            DefaultGateway = defaultGateway;
            DnsServers = dnsServers;
            DefaultIsolationId = defaultIsolationId;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Adapter Name of NIC. </summary>
        [WirePath("adapterName")]
        public string AdapterName { get; set; }
        /// <summary> Interface Description of NIC. </summary>
        [WirePath("interfaceDescription")]
        public string InterfaceDescription { get; set; }
        /// <summary> Component Id of NIC. </summary>
        [WirePath("componentId")]
        public string ComponentId { get; set; }
        /// <summary> Driver Version of NIC. </summary>
        [WirePath("driverVersion")]
        public string DriverVersion { get; set; }
        /// <summary> Subnet Mask of NIC. </summary>
        [WirePath("ip4Address")]
        public string IPv4Address { get; set; }
        /// <summary> Subnet Mask of NIC. </summary>
        [WirePath("subnetMask")]
        public string SubnetMask { get; set; }
        /// <summary> Default Gateway of NIC. </summary>
        [WirePath("defaultGateway")]
        public string DefaultGateway { get; set; }
        /// <summary> DNS Servers for NIC. </summary>
        [WirePath("dnsServers")]
        public IList<string> DnsServers { get; }
        /// <summary> Default Isolation of Management NIC. </summary>
        [WirePath("defaultIsolationId")]
        public string DefaultIsolationId { get; set; }
    }
}
