// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> The Intents of a cluster. </summary>
    public partial class HciEdgeDeviceIntents
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HciEdgeDeviceIntents"/>. </summary>
        internal HciEdgeDeviceIntents()
        {
            IntentAdapters = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="HciEdgeDeviceIntents"/>. </summary>
        /// <param name="scope"> Scope for host network intent. </param>
        /// <param name="intentType"> IntentType for host network intent. </param>
        /// <param name="isComputeIntentSet"> IsComputeIntentSet for host network intent. </param>
        /// <param name="isStorageIntentSet"> IsStorageIntentSet for host network intent. </param>
        /// <param name="isOnlyStorage"> IntentType for host network intent. </param>
        /// <param name="isManagementIntentSet"> IsManagementIntentSet for host network intent. </param>
        /// <param name="isStretchIntentSet"> IsStretchIntentSet for host network intent. </param>
        /// <param name="isOnlyStretch"> IsOnlyStretch for host network intent. </param>
        /// <param name="isNetworkIntentType"> IsNetworkIntentType for host network intent. </param>
        /// <param name="intentName"> Name of the network intent you wish to create. </param>
        /// <param name="intentAdapters"> Array of adapters used for the network intent. </param>
        /// <param name="overrideVirtualSwitchConfiguration"> This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation. </param>
        /// <param name="virtualSwitchConfigurationOverrides"> Set virtualSwitch ConfigurationOverrides for cluster. </param>
        /// <param name="overrideQosPolicy"> This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation. </param>
        /// <param name="qosPolicyOverrides"> Set QoS PolicyOverrides for cluster. </param>
        /// <param name="overrideAdapterProperty"> This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation. </param>
        /// <param name="adapterPropertyOverrides"> Set Adapter PropertyOverrides for cluster. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HciEdgeDeviceIntents(long? scope, long? intentType, bool? isComputeIntentSet, bool? isStorageIntentSet, bool? isOnlyStorage, bool? isManagementIntentSet, bool? isStretchIntentSet, bool? isOnlyStretch, bool? isNetworkIntentType, string intentName, IReadOnlyList<string> intentAdapters, bool? overrideVirtualSwitchConfiguration, HciEdgeDeviceVirtualSwitchConfigurationOverrides virtualSwitchConfigurationOverrides, bool? overrideQosPolicy, DeploymentSettingQosPolicyOverrides qosPolicyOverrides, bool? overrideAdapterProperty, HciEdgeDeviceAdapterPropertyOverrides adapterPropertyOverrides, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Scope = scope;
            IntentType = intentType;
            IsComputeIntentSet = isComputeIntentSet;
            IsStorageIntentSet = isStorageIntentSet;
            IsOnlyStorage = isOnlyStorage;
            IsManagementIntentSet = isManagementIntentSet;
            IsStretchIntentSet = isStretchIntentSet;
            IsOnlyStretch = isOnlyStretch;
            IsNetworkIntentType = isNetworkIntentType;
            IntentName = intentName;
            IntentAdapters = intentAdapters;
            OverrideVirtualSwitchConfiguration = overrideVirtualSwitchConfiguration;
            VirtualSwitchConfigurationOverrides = virtualSwitchConfigurationOverrides;
            OverrideQosPolicy = overrideQosPolicy;
            QosPolicyOverrides = qosPolicyOverrides;
            OverrideAdapterProperty = overrideAdapterProperty;
            AdapterPropertyOverrides = adapterPropertyOverrides;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Scope for host network intent. </summary>
        [WirePath("scope")]
        public long? Scope { get; }
        /// <summary> IntentType for host network intent. </summary>
        [WirePath("intentType")]
        public long? IntentType { get; }
        /// <summary> IsComputeIntentSet for host network intent. </summary>
        [WirePath("isComputeIntentSet")]
        public bool? IsComputeIntentSet { get; }
        /// <summary> IsStorageIntentSet for host network intent. </summary>
        [WirePath("isStorageIntentSet")]
        public bool? IsStorageIntentSet { get; }
        /// <summary> IntentType for host network intent. </summary>
        [WirePath("isOnlyStorage")]
        public bool? IsOnlyStorage { get; }
        /// <summary> IsManagementIntentSet for host network intent. </summary>
        [WirePath("isManagementIntentSet")]
        public bool? IsManagementIntentSet { get; }
        /// <summary> IsStretchIntentSet for host network intent. </summary>
        [WirePath("isStretchIntentSet")]
        public bool? IsStretchIntentSet { get; }
        /// <summary> IsOnlyStretch for host network intent. </summary>
        [WirePath("isOnlyStretch")]
        public bool? IsOnlyStretch { get; }
        /// <summary> IsNetworkIntentType for host network intent. </summary>
        [WirePath("isNetworkIntentType")]
        public bool? IsNetworkIntentType { get; }
        /// <summary> Name of the network intent you wish to create. </summary>
        [WirePath("intentName")]
        public string IntentName { get; }
        /// <summary> Array of adapters used for the network intent. </summary>
        [WirePath("intentAdapters")]
        public IReadOnlyList<string> IntentAdapters { get; }
        /// <summary> This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation. </summary>
        [WirePath("overrideVirtualSwitchConfiguration")]
        public bool? OverrideVirtualSwitchConfiguration { get; }
        /// <summary> Set virtualSwitch ConfigurationOverrides for cluster. </summary>
        [WirePath("virtualSwitchConfigurationOverrides")]
        public HciEdgeDeviceVirtualSwitchConfigurationOverrides VirtualSwitchConfigurationOverrides { get; }
        /// <summary> This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation. </summary>
        [WirePath("overrideQosPolicy")]
        public bool? OverrideQosPolicy { get; }
        /// <summary> Set QoS PolicyOverrides for cluster. </summary>
        [WirePath("qosPolicyOverrides")]
        public DeploymentSettingQosPolicyOverrides QosPolicyOverrides { get; }
        /// <summary> This parameter should only be modified based on your OEM guidance. Do not modify this parameter without OEM validation. </summary>
        [WirePath("overrideAdapterProperty")]
        public bool? OverrideAdapterProperty { get; }
        /// <summary> Set Adapter PropertyOverrides for cluster. </summary>
        [WirePath("adapterPropertyOverrides")]
        public HciEdgeDeviceAdapterPropertyOverrides AdapterPropertyOverrides { get; }
    }
}
