// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Hci.Models
{
    public partial class HciEdgeDeviceHostNetwork : IUtf8JsonSerializable, IJsonModel<HciEdgeDeviceHostNetwork>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<HciEdgeDeviceHostNetwork>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<HciEdgeDeviceHostNetwork>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HciEdgeDeviceHostNetwork>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HciEdgeDeviceHostNetwork)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsCollectionDefined(Intents))
            {
                writer.WritePropertyName("intents"u8);
                writer.WriteStartArray();
                foreach (var item in Intents)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(StorageNetworks))
            {
                writer.WritePropertyName("storageNetworks"u8);
                writer.WriteStartArray();
                foreach (var item in StorageNetworks)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(StorageConnectivitySwitchless))
            {
                writer.WritePropertyName("storageConnectivitySwitchless"u8);
                writer.WriteBooleanValue(StorageConnectivitySwitchless.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(EnableStorageAutoIP))
            {
                writer.WritePropertyName("enableStorageAutoIp"u8);
                writer.WriteBooleanValue(EnableStorageAutoIP.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        HciEdgeDeviceHostNetwork IJsonModel<HciEdgeDeviceHostNetwork>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HciEdgeDeviceHostNetwork>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HciEdgeDeviceHostNetwork)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeHciEdgeDeviceHostNetwork(document.RootElement, options);
        }

        internal static HciEdgeDeviceHostNetwork DeserializeHciEdgeDeviceHostNetwork(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            IReadOnlyList<HciEdgeDeviceIntents> intents = default;
            IReadOnlyList<HciEdgeDeviceStorageNetworks> storageNetworks = default;
            bool? storageConnectivitySwitchless = default;
            bool? enableStorageAutoIP = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("intents"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<HciEdgeDeviceIntents> array = new List<HciEdgeDeviceIntents>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(HciEdgeDeviceIntents.DeserializeHciEdgeDeviceIntents(item, options));
                    }
                    intents = array;
                    continue;
                }
                if (property.NameEquals("storageNetworks"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<HciEdgeDeviceStorageNetworks> array = new List<HciEdgeDeviceStorageNetworks>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(HciEdgeDeviceStorageNetworks.DeserializeHciEdgeDeviceStorageNetworks(item, options));
                    }
                    storageNetworks = array;
                    continue;
                }
                if (property.NameEquals("storageConnectivitySwitchless"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    storageConnectivitySwitchless = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("enableStorageAutoIp"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    enableStorageAutoIP = property.Value.GetBoolean();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new HciEdgeDeviceHostNetwork(intents ?? new ChangeTrackingList<HciEdgeDeviceIntents>(), storageNetworks ?? new ChangeTrackingList<HciEdgeDeviceStorageNetworks>(), storageConnectivitySwitchless, enableStorageAutoIP, serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Intents), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  intents: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Intents))
                {
                    if (Intents.Any())
                    {
                        builder.Append("  intents: ");
                        builder.AppendLine("[");
                        foreach (var item in Intents)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  intents: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(StorageNetworks), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  storageNetworks: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(StorageNetworks))
                {
                    if (StorageNetworks.Any())
                    {
                        builder.Append("  storageNetworks: ");
                        builder.AppendLine("[");
                        foreach (var item in StorageNetworks)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  storageNetworks: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(StorageConnectivitySwitchless), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  storageConnectivitySwitchless: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(StorageConnectivitySwitchless))
                {
                    builder.Append("  storageConnectivitySwitchless: ");
                    var boolValue = StorageConnectivitySwitchless.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(EnableStorageAutoIP), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  enableStorageAutoIp: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(EnableStorageAutoIP))
                {
                    builder.Append("  enableStorageAutoIp: ");
                    var boolValue = EnableStorageAutoIP.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<HciEdgeDeviceHostNetwork>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HciEdgeDeviceHostNetwork>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(HciEdgeDeviceHostNetwork)} does not support writing '{options.Format}' format.");
            }
        }

        HciEdgeDeviceHostNetwork IPersistableModel<HciEdgeDeviceHostNetwork>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HciEdgeDeviceHostNetwork>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeHciEdgeDeviceHostNetwork(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(HciEdgeDeviceHostNetwork)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<HciEdgeDeviceHostNetwork>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
