// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> The device Configuration for edge device. </summary>
    public partial class HciEdgeDeviceConfiguration
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HciEdgeDeviceConfiguration"/>. </summary>
        public HciEdgeDeviceConfiguration()
        {
            NicDetails = new ChangeTrackingList<HciEdgeDeviceNicDetail>();
        }

        /// <summary> Initializes a new instance of <see cref="HciEdgeDeviceConfiguration"/>. </summary>
        /// <param name="nicDetails"> NIC Details of device. </param>
        /// <param name="deviceMetadata"> Device metadata details. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HciEdgeDeviceConfiguration(IList<HciEdgeDeviceNicDetail> nicDetails, string deviceMetadata, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            NicDetails = nicDetails;
            DeviceMetadata = deviceMetadata;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> NIC Details of device. </summary>
        [WirePath("nicDetails")]
        public IList<HciEdgeDeviceNicDetail> NicDetails { get; }
        /// <summary> Device metadata details. </summary>
        [WirePath("deviceMetadata")]
        public string DeviceMetadata { get; set; }
    }
}
