// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> AzureStackHCI Cluster deployment properties. </summary>
    public partial class HciDeploymentCluster
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HciDeploymentCluster"/>. </summary>
        public HciDeploymentCluster()
        {
        }

        /// <summary> Initializes a new instance of <see cref="HciDeploymentCluster"/>. </summary>
        /// <param name="name"> The cluster name provided when preparing Active Directory. </param>
        /// <param name="witnessType"> Use a cloud witness if you have internet access and if you use an Azure Storage account to provide a vote on cluster quorum. A cloud witness uses Azure Blob Storage to read or write a blob file and then uses it to arbitrate in split-brain resolution. Only allowed values are 'Cloud', 'FileShare'. </param>
        /// <param name="witnessPath"> Specify the fileshare path for the local witness for your Azure Stack HCI cluster. </param>
        /// <param name="cloudAccountName"> Specify the Azure Storage account name for cloud witness for your Azure Stack HCI cluster. </param>
        /// <param name="azureServiceEndpoint"> For Azure blob service endpoint type, select either Default or Custom domain. If you selected **Custom domain, enter the domain for the blob service in this format core.windows.net. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HciDeploymentCluster(string name, string witnessType, string witnessPath, string cloudAccountName, string azureServiceEndpoint, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            WitnessType = witnessType;
            WitnessPath = witnessPath;
            CloudAccountName = cloudAccountName;
            AzureServiceEndpoint = azureServiceEndpoint;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> The cluster name provided when preparing Active Directory. </summary>
        [WirePath("name")]
        public string Name { get; set; }
        /// <summary> Use a cloud witness if you have internet access and if you use an Azure Storage account to provide a vote on cluster quorum. A cloud witness uses Azure Blob Storage to read or write a blob file and then uses it to arbitrate in split-brain resolution. Only allowed values are 'Cloud', 'FileShare'. </summary>
        [WirePath("witnessType")]
        public string WitnessType { get; set; }
        /// <summary> Specify the fileshare path for the local witness for your Azure Stack HCI cluster. </summary>
        [WirePath("witnessPath")]
        public string WitnessPath { get; set; }
        /// <summary> Specify the Azure Storage account name for cloud witness for your Azure Stack HCI cluster. </summary>
        [WirePath("cloudAccountName")]
        public string CloudAccountName { get; set; }
        /// <summary> For Azure blob service endpoint type, select either Default or Custom domain. If you selected **Custom domain, enter the domain for the blob service in this format core.windows.net. </summary>
        [WirePath("azureServiceEndpoint")]
        public string AzureServiceEndpoint { get; set; }
    }
}
