// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> Overall update state of the stamp. </summary>
    public readonly partial struct HciClusterUpdateState : IEquatable<HciClusterUpdateState>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HciClusterUpdateState"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HciClusterUpdateState(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string UnknownValue = "Unknown";
        private const string AppliedSuccessfullyValue = "AppliedSuccessfully";
        private const string UpdateAvailableValue = "UpdateAvailable";
        private const string UpdateInProgressValue = "UpdateInProgress";
        private const string UpdateFailedValue = "UpdateFailed";
        private const string NeedsAttentionValue = "NeedsAttention";
        private const string PreparationInProgressValue = "PreparationInProgress";
        private const string PreparationFailedValue = "PreparationFailed";

        /// <summary> Unknown. </summary>
        public static HciClusterUpdateState Unknown { get; } = new HciClusterUpdateState(UnknownValue);
        /// <summary> AppliedSuccessfully. </summary>
        public static HciClusterUpdateState AppliedSuccessfully { get; } = new HciClusterUpdateState(AppliedSuccessfullyValue);
        /// <summary> UpdateAvailable. </summary>
        public static HciClusterUpdateState UpdateAvailable { get; } = new HciClusterUpdateState(UpdateAvailableValue);
        /// <summary> UpdateInProgress. </summary>
        public static HciClusterUpdateState UpdateInProgress { get; } = new HciClusterUpdateState(UpdateInProgressValue);
        /// <summary> UpdateFailed. </summary>
        public static HciClusterUpdateState UpdateFailed { get; } = new HciClusterUpdateState(UpdateFailedValue);
        /// <summary> NeedsAttention. </summary>
        public static HciClusterUpdateState NeedsAttention { get; } = new HciClusterUpdateState(NeedsAttentionValue);
        /// <summary> PreparationInProgress. </summary>
        public static HciClusterUpdateState PreparationInProgress { get; } = new HciClusterUpdateState(PreparationInProgressValue);
        /// <summary> PreparationFailed. </summary>
        public static HciClusterUpdateState PreparationFailed { get; } = new HciClusterUpdateState(PreparationFailedValue);
        /// <summary> Determines if two <see cref="HciClusterUpdateState"/> values are the same. </summary>
        public static bool operator ==(HciClusterUpdateState left, HciClusterUpdateState right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HciClusterUpdateState"/> values are not the same. </summary>
        public static bool operator !=(HciClusterUpdateState left, HciClusterUpdateState right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HciClusterUpdateState"/>. </summary>
        public static implicit operator HciClusterUpdateState(string value) => new HciClusterUpdateState(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HciClusterUpdateState other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HciClusterUpdateState other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
