// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> If update State is HasPrerequisite, this property contains an array of objects describing prerequisite updates before installing this update. Otherwise, it is empty. </summary>
    public partial class HciClusterUpdatePrerequisite
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HciClusterUpdatePrerequisite"/>. </summary>
        public HciClusterUpdatePrerequisite()
        {
        }

        /// <summary> Initializes a new instance of <see cref="HciClusterUpdatePrerequisite"/>. </summary>
        /// <param name="updateType"> Updatable component type. </param>
        /// <param name="version"> Version of the prerequisite. </param>
        /// <param name="packageName"> Friendly name of the prerequisite. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HciClusterUpdatePrerequisite(string updateType, string version, string packageName, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            UpdateType = updateType;
            Version = version;
            PackageName = packageName;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Updatable component type. </summary>
        [WirePath("updateType")]
        public string UpdateType { get; set; }
        /// <summary> Version of the prerequisite. </summary>
        [WirePath("version")]
        public string Version { get; set; }
        /// <summary> Friendly name of the prerequisite. </summary>
        [WirePath("packageName")]
        public string PackageName { get; set; }
    }
}
