// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> Properties reported by cluster agent. </summary>
    public partial class HciClusterReportedProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HciClusterReportedProperties"/>. </summary>
        internal HciClusterReportedProperties()
        {
            Nodes = new ChangeTrackingList<HciClusterNode>();
            SupportedCapabilities = new ChangeTrackingList<string>();
        }

        /// <summary> Initializes a new instance of <see cref="HciClusterReportedProperties"/>. </summary>
        /// <param name="clusterName"> Name of the on-prem cluster connected to this resource. </param>
        /// <param name="clusterId"> Unique id generated by the on-prem cluster. </param>
        /// <param name="clusterVersion"> Version of the cluster software. </param>
        /// <param name="nodes"> List of nodes reported by the cluster. </param>
        /// <param name="lastUpdatedOn"> Last time the cluster reported the data. </param>
        /// <param name="imdsAttestation"> IMDS attestation status of the cluster. </param>
        /// <param name="diagnosticLevel"> Level of diagnostic data emitted by the cluster. </param>
        /// <param name="supportedCapabilities"> Capabilities supported by the cluster. </param>
        /// <param name="clusterType"> The node type of all the nodes of the cluster. </param>
        /// <param name="manufacturer"> The manufacturer of all the nodes of the cluster. </param>
        /// <param name="oemActivation"> OEM activation status of the cluster. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HciClusterReportedProperties(string clusterName, Guid? clusterId, string clusterVersion, IReadOnlyList<HciClusterNode> nodes, DateTimeOffset? lastUpdatedOn, ImdsAttestationState? imdsAttestation, HciClusterDiagnosticLevel? diagnosticLevel, IReadOnlyList<string> supportedCapabilities, ClusterNodeType? clusterType, string manufacturer, OemActivation? oemActivation, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            ClusterName = clusterName;
            ClusterId = clusterId;
            ClusterVersion = clusterVersion;
            Nodes = nodes;
            LastUpdatedOn = lastUpdatedOn;
            ImdsAttestation = imdsAttestation;
            DiagnosticLevel = diagnosticLevel;
            SupportedCapabilities = supportedCapabilities;
            ClusterType = clusterType;
            Manufacturer = manufacturer;
            OemActivation = oemActivation;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the on-prem cluster connected to this resource. </summary>
        [WirePath("clusterName")]
        public string ClusterName { get; }
        /// <summary> Unique id generated by the on-prem cluster. </summary>
        [WirePath("clusterId")]
        public Guid? ClusterId { get; }
        /// <summary> Version of the cluster software. </summary>
        [WirePath("clusterVersion")]
        public string ClusterVersion { get; }
        /// <summary> List of nodes reported by the cluster. </summary>
        [WirePath("nodes")]
        public IReadOnlyList<HciClusterNode> Nodes { get; }
        /// <summary> Last time the cluster reported the data. </summary>
        [WirePath("lastUpdated")]
        public DateTimeOffset? LastUpdatedOn { get; }
        /// <summary> IMDS attestation status of the cluster. </summary>
        [WirePath("imdsAttestation")]
        public ImdsAttestationState? ImdsAttestation { get; }
        /// <summary> Level of diagnostic data emitted by the cluster. </summary>
        [WirePath("diagnosticLevel")]
        public HciClusterDiagnosticLevel? DiagnosticLevel { get; }
        /// <summary> Capabilities supported by the cluster. </summary>
        [WirePath("supportedCapabilities")]
        public IReadOnlyList<string> SupportedCapabilities { get; }
        /// <summary> The node type of all the nodes of the cluster. </summary>
        [WirePath("clusterType")]
        public ClusterNodeType? ClusterType { get; }
        /// <summary> The manufacturer of all the nodes of the cluster. </summary>
        [WirePath("manufacturer")]
        public string Manufacturer { get; }
        /// <summary> OEM activation status of the cluster. </summary>
        [WirePath("oemActivation")]
        public OemActivation? OemActivation { get; }
    }
}
