// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Hci.Models
{
    public partial class HciClusterReportedProperties : IUtf8JsonSerializable, IJsonModel<HciClusterReportedProperties>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<HciClusterReportedProperties>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<HciClusterReportedProperties>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HciClusterReportedProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HciClusterReportedProperties)} does not support writing '{format}' format.");
            }

            if (options.Format != "W" && Optional.IsDefined(ClusterName))
            {
                writer.WritePropertyName("clusterName"u8);
                writer.WriteStringValue(ClusterName);
            }
            if (options.Format != "W" && Optional.IsDefined(ClusterId))
            {
                writer.WritePropertyName("clusterId"u8);
                writer.WriteStringValue(ClusterId.Value);
            }
            if (options.Format != "W" && Optional.IsDefined(ClusterVersion))
            {
                writer.WritePropertyName("clusterVersion"u8);
                writer.WriteStringValue(ClusterVersion);
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(Nodes))
            {
                writer.WritePropertyName("nodes"u8);
                writer.WriteStartArray();
                foreach (var item in Nodes)
                {
                    writer.WriteObjectValue(item, options);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(LastUpdatedOn))
            {
                writer.WritePropertyName("lastUpdated"u8);
                writer.WriteStringValue(LastUpdatedOn.Value, "O");
            }
            if (options.Format != "W" && Optional.IsDefined(ImdsAttestation))
            {
                writer.WritePropertyName("imdsAttestation"u8);
                writer.WriteStringValue(ImdsAttestation.Value.ToString());
            }
            if (Optional.IsDefined(DiagnosticLevel))
            {
                writer.WritePropertyName("diagnosticLevel"u8);
                writer.WriteStringValue(DiagnosticLevel.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsCollectionDefined(SupportedCapabilities))
            {
                writer.WritePropertyName("supportedCapabilities"u8);
                writer.WriteStartArray();
                foreach (var item in SupportedCapabilities)
                {
                    writer.WriteStringValue(item);
                }
                writer.WriteEndArray();
            }
            if (options.Format != "W" && Optional.IsDefined(ClusterType))
            {
                writer.WritePropertyName("clusterType"u8);
                writer.WriteStringValue(ClusterType.Value.ToString());
            }
            if (options.Format != "W" && Optional.IsDefined(Manufacturer))
            {
                writer.WritePropertyName("manufacturer"u8);
                writer.WriteStringValue(Manufacturer);
            }
            if (options.Format != "W" && Optional.IsDefined(OemActivation))
            {
                writer.WritePropertyName("oemActivation"u8);
                writer.WriteStringValue(OemActivation.Value.ToString());
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        HciClusterReportedProperties IJsonModel<HciClusterReportedProperties>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HciClusterReportedProperties>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HciClusterReportedProperties)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeHciClusterReportedProperties(document.RootElement, options);
        }

        internal static HciClusterReportedProperties DeserializeHciClusterReportedProperties(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            string clusterName = default;
            Guid? clusterId = default;
            string clusterVersion = default;
            IReadOnlyList<HciClusterNode> nodes = default;
            DateTimeOffset? lastUpdated = default;
            ImdsAttestationState? imdsAttestation = default;
            HciClusterDiagnosticLevel? diagnosticLevel = default;
            IReadOnlyList<string> supportedCapabilities = default;
            ClusterNodeType? clusterType = default;
            string manufacturer = default;
            OemActivation? oemActivation = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("clusterName"u8))
                {
                    clusterName = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("clusterId"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    clusterId = property.Value.GetGuid();
                    continue;
                }
                if (property.NameEquals("clusterVersion"u8))
                {
                    clusterVersion = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("nodes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<HciClusterNode> array = new List<HciClusterNode>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(HciClusterNode.DeserializeHciClusterNode(item, options));
                    }
                    nodes = array;
                    continue;
                }
                if (property.NameEquals("lastUpdated"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    lastUpdated = property.Value.GetDateTimeOffset("O");
                    continue;
                }
                if (property.NameEquals("imdsAttestation"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    imdsAttestation = new ImdsAttestationState(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("diagnosticLevel"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    diagnosticLevel = new HciClusterDiagnosticLevel(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("supportedCapabilities"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    List<string> array = new List<string>();
                    foreach (var item in property.Value.EnumerateArray())
                    {
                        array.Add(item.GetString());
                    }
                    supportedCapabilities = array;
                    continue;
                }
                if (property.NameEquals("clusterType"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    clusterType = new ClusterNodeType(property.Value.GetString());
                    continue;
                }
                if (property.NameEquals("manufacturer"u8))
                {
                    manufacturer = property.Value.GetString();
                    continue;
                }
                if (property.NameEquals("oemActivation"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    oemActivation = new OemActivation(property.Value.GetString());
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new HciClusterReportedProperties(
                clusterName,
                clusterId,
                clusterVersion,
                nodes ?? new ChangeTrackingList<HciClusterNode>(),
                lastUpdated,
                imdsAttestation,
                diagnosticLevel,
                supportedCapabilities ?? new ChangeTrackingList<string>(),
                clusterType,
                manufacturer,
                oemActivation,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ClusterName), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  clusterName: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ClusterName))
                {
                    builder.Append("  clusterName: ");
                    if (ClusterName.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ClusterName}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ClusterName}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ClusterId), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  clusterId: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ClusterId))
                {
                    builder.Append("  clusterId: ");
                    builder.AppendLine($"'{ClusterId.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ClusterVersion), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  clusterVersion: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ClusterVersion))
                {
                    builder.Append("  clusterVersion: ");
                    if (ClusterVersion.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{ClusterVersion}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{ClusterVersion}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Nodes), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  nodes: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(Nodes))
                {
                    if (Nodes.Any())
                    {
                        builder.Append("  nodes: ");
                        builder.AppendLine("[");
                        foreach (var item in Nodes)
                        {
                            BicepSerializationHelpers.AppendChildObject(builder, item, options, 4, true, "  nodes: ");
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(LastUpdatedOn), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  lastUpdated: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(LastUpdatedOn))
                {
                    builder.Append("  lastUpdated: ");
                    var formattedDateTimeString = TypeFormatters.ToString(LastUpdatedOn.Value, "o");
                    builder.AppendLine($"'{formattedDateTimeString}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ImdsAttestation), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  imdsAttestation: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ImdsAttestation))
                {
                    builder.Append("  imdsAttestation: ");
                    builder.AppendLine($"'{ImdsAttestation.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(DiagnosticLevel), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  diagnosticLevel: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(DiagnosticLevel))
                {
                    builder.Append("  diagnosticLevel: ");
                    builder.AppendLine($"'{DiagnosticLevel.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(SupportedCapabilities), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  supportedCapabilities: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsCollectionDefined(SupportedCapabilities))
                {
                    if (SupportedCapabilities.Any())
                    {
                        builder.Append("  supportedCapabilities: ");
                        builder.AppendLine("[");
                        foreach (var item in SupportedCapabilities)
                        {
                            if (item == null)
                            {
                                builder.Append("null");
                                continue;
                            }
                            if (item.Contains(Environment.NewLine))
                            {
                                builder.AppendLine("    '''");
                                builder.AppendLine($"{item}'''");
                            }
                            else
                            {
                                builder.AppendLine($"    '{item}'");
                            }
                        }
                        builder.AppendLine("  ]");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(ClusterType), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  clusterType: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(ClusterType))
                {
                    builder.Append("  clusterType: ");
                    builder.AppendLine($"'{ClusterType.Value.ToString()}'");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(Manufacturer), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  manufacturer: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(Manufacturer))
                {
                    builder.Append("  manufacturer: ");
                    if (Manufacturer.Contains(Environment.NewLine))
                    {
                        builder.AppendLine("'''");
                        builder.AppendLine($"{Manufacturer}'''");
                    }
                    else
                    {
                        builder.AppendLine($"'{Manufacturer}'");
                    }
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(OemActivation), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  oemActivation: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(OemActivation))
                {
                    builder.Append("  oemActivation: ");
                    builder.AppendLine($"'{OemActivation.Value.ToString()}'");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<HciClusterReportedProperties>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HciClusterReportedProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(HciClusterReportedProperties)} does not support writing '{options.Format}' format.");
            }
        }

        HciClusterReportedProperties IPersistableModel<HciClusterReportedProperties>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HciClusterReportedProperties>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeHciClusterReportedProperties(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(HciClusterReportedProperties)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<HciClusterReportedProperties>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
