// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ComponentModel;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> The intended operation for a cluster. </summary>
    public readonly partial struct HciClusterOperationType : IEquatable<HciClusterOperationType>
    {
        private readonly string _value;

        /// <summary> Initializes a new instance of <see cref="HciClusterOperationType"/>. </summary>
        /// <exception cref="ArgumentNullException"> <paramref name="value"/> is null. </exception>
        public HciClusterOperationType(string value)
        {
            _value = value ?? throw new ArgumentNullException(nameof(value));
        }

        private const string ClusterProvisioningValue = "ClusterProvisioning";
        private const string ClusterUpgradeValue = "ClusterUpgrade";

        /// <summary> Cluster provisioning operation. </summary>
        public static HciClusterOperationType ClusterProvisioning { get; } = new HciClusterOperationType(ClusterProvisioningValue);
        /// <summary> Cluster upgrade operation. </summary>
        public static HciClusterOperationType ClusterUpgrade { get; } = new HciClusterOperationType(ClusterUpgradeValue);
        /// <summary> Determines if two <see cref="HciClusterOperationType"/> values are the same. </summary>
        public static bool operator ==(HciClusterOperationType left, HciClusterOperationType right) => left.Equals(right);
        /// <summary> Determines if two <see cref="HciClusterOperationType"/> values are not the same. </summary>
        public static bool operator !=(HciClusterOperationType left, HciClusterOperationType right) => !left.Equals(right);
        /// <summary> Converts a <see cref="string"/> to a <see cref="HciClusterOperationType"/>. </summary>
        public static implicit operator HciClusterOperationType(string value) => new HciClusterOperationType(value);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override bool Equals(object obj) => obj is HciClusterOperationType other && Equals(other);
        /// <inheritdoc />
        public bool Equals(HciClusterOperationType other) => string.Equals(_value, other._value, StringComparison.InvariantCultureIgnoreCase);

        /// <inheritdoc />
        [EditorBrowsable(EditorBrowsableState.Never)]
        public override int GetHashCode() => _value != null ? StringComparer.InvariantCultureIgnoreCase.GetHashCode(_value) : 0;
        /// <inheritdoc />
        public override string ToString() => _value;
    }
}
