// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> Cluster node details. </summary>
    public partial class HciClusterNode
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HciClusterNode"/>. </summary>
        internal HciClusterNode()
        {
        }

        /// <summary> Initializes a new instance of <see cref="HciClusterNode"/>. </summary>
        /// <param name="name"> Name of the cluster node. </param>
        /// <param name="id"> Id of the node in the cluster. </param>
        /// <param name="windowsServerSubscription"> State of Windows Server Subscription. </param>
        /// <param name="nodeType"> Type of the cluster node hardware. </param>
        /// <param name="ehcResourceId"> Edge Hardware Center Resource Id. </param>
        /// <param name="manufacturer"> Manufacturer of the cluster node hardware. </param>
        /// <param name="model"> Model name of the cluster node hardware. </param>
        /// <param name="osName"> Operating system running on the cluster node. </param>
        /// <param name="osVersion"> Version of the operating system running on the cluster node. </param>
        /// <param name="osDisplayVersion"> Display version of the operating system running on the cluster node. </param>
        /// <param name="serialNumber"> Immutable id of the cluster node. </param>
        /// <param name="coreCount"> Number of physical cores on the cluster node. </param>
        /// <param name="memoryInGiB"> Total available memory on the cluster node (in GiB). </param>
        /// <param name="lastLicensingTimestamp"> Most recent licensing timestamp. </param>
        /// <param name="oemActivation"> OEM activation status of the node. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HciClusterNode(string name, float? id, WindowsServerSubscription? windowsServerSubscription, ClusterNodeType? nodeType, string ehcResourceId, string manufacturer, string model, string osName, string osVersion, string osDisplayVersion, string serialNumber, float? coreCount, float? memoryInGiB, DateTimeOffset? lastLicensingTimestamp, OemActivation? oemActivation, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            Name = name;
            Id = id;
            WindowsServerSubscription = windowsServerSubscription;
            NodeType = nodeType;
            EhcResourceId = ehcResourceId;
            Manufacturer = manufacturer;
            Model = model;
            OSName = osName;
            OSVersion = osVersion;
            OSDisplayVersion = osDisplayVersion;
            SerialNumber = serialNumber;
            CoreCount = coreCount;
            MemoryInGiB = memoryInGiB;
            LastLicensingTimestamp = lastLicensingTimestamp;
            OemActivation = oemActivation;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Name of the cluster node. </summary>
        [WirePath("name")]
        public string Name { get; }
        /// <summary> Id of the node in the cluster. </summary>
        [WirePath("id")]
        public float? Id { get; }
        /// <summary> State of Windows Server Subscription. </summary>
        [WirePath("windowsServerSubscription")]
        public WindowsServerSubscription? WindowsServerSubscription { get; }
        /// <summary> Type of the cluster node hardware. </summary>
        [WirePath("nodeType")]
        public ClusterNodeType? NodeType { get; }
        /// <summary> Edge Hardware Center Resource Id. </summary>
        [WirePath("ehcResourceId")]
        public string EhcResourceId { get; }
        /// <summary> Manufacturer of the cluster node hardware. </summary>
        [WirePath("manufacturer")]
        public string Manufacturer { get; }
        /// <summary> Model name of the cluster node hardware. </summary>
        [WirePath("model")]
        public string Model { get; }
        /// <summary> Operating system running on the cluster node. </summary>
        [WirePath("osName")]
        public string OSName { get; }
        /// <summary> Version of the operating system running on the cluster node. </summary>
        [WirePath("osVersion")]
        public string OSVersion { get; }
        /// <summary> Display version of the operating system running on the cluster node. </summary>
        [WirePath("osDisplayVersion")]
        public string OSDisplayVersion { get; }
        /// <summary> Immutable id of the cluster node. </summary>
        [WirePath("serialNumber")]
        public string SerialNumber { get; }
        /// <summary> Number of physical cores on the cluster node. </summary>
        [WirePath("coreCount")]
        public float? CoreCount { get; }
        /// <summary> Total available memory on the cluster node (in GiB). </summary>
        [WirePath("memoryInGiB")]
        public float? MemoryInGiB { get; }
        /// <summary> Most recent licensing timestamp. </summary>
        [WirePath("lastLicensingTimestamp")]
        public DateTimeOffset? LastLicensingTimestamp { get; }
        /// <summary> OEM activation status of the node. </summary>
        [WirePath("oemActivation")]
        public OemActivation? OemActivation { get; }
    }
}
