// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> Desired properties of the cluster. </summary>
    public partial class HciClusterDesiredProperties
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HciClusterDesiredProperties"/>. </summary>
        public HciClusterDesiredProperties()
        {
        }

        /// <summary> Initializes a new instance of <see cref="HciClusterDesiredProperties"/>. </summary>
        /// <param name="windowsServerSubscription"> Desired state of Windows Server Subscription. </param>
        /// <param name="diagnosticLevel"> Desired level of diagnostic data emitted by the cluster. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HciClusterDesiredProperties(WindowsServerSubscription? windowsServerSubscription, HciClusterDiagnosticLevel? diagnosticLevel, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            WindowsServerSubscription = windowsServerSubscription;
            DiagnosticLevel = diagnosticLevel;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> Desired state of Windows Server Subscription. </summary>
        [WirePath("windowsServerSubscription")]
        public WindowsServerSubscription? WindowsServerSubscription { get; set; }
        /// <summary> Desired level of diagnostic data emitted by the cluster. </summary>
        [WirePath("diagnosticLevel")]
        public HciClusterDiagnosticLevel? DiagnosticLevel { get; set; }
    }
}
