// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.ClientModel.Primitives;
using System.Collections.Generic;
using System.Text;
using System.Text.Json;
using Azure.Core;

namespace Azure.ResourceManager.Hci.Models
{
    public partial class HciClusterDeploymentSecuritySettings : IUtf8JsonSerializable, IJsonModel<HciClusterDeploymentSecuritySettings>
    {
        void IUtf8JsonSerializable.Write(Utf8JsonWriter writer) => ((IJsonModel<HciClusterDeploymentSecuritySettings>)this).Write(writer, ModelSerializationExtensions.WireOptions);

        void IJsonModel<HciClusterDeploymentSecuritySettings>.Write(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            writer.WriteStartObject();
            JsonModelWriteCore(writer, options);
            writer.WriteEndObject();
        }

        /// <param name="writer"> The JSON writer. </param>
        /// <param name="options"> The client options for reading and writing models. </param>
        protected virtual void JsonModelWriteCore(Utf8JsonWriter writer, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HciClusterDeploymentSecuritySettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HciClusterDeploymentSecuritySettings)} does not support writing '{format}' format.");
            }

            if (Optional.IsDefined(IsHvciProtectionEnabled))
            {
                writer.WritePropertyName("hvciProtection"u8);
                writer.WriteBooleanValue(IsHvciProtectionEnabled.Value);
            }
            if (Optional.IsDefined(IsDrtmProtectionEnabled))
            {
                writer.WritePropertyName("drtmProtection"u8);
                writer.WriteBooleanValue(IsDrtmProtectionEnabled.Value);
            }
            if (Optional.IsDefined(IsDriftControlEnforced))
            {
                writer.WritePropertyName("driftControlEnforced"u8);
                writer.WriteBooleanValue(IsDriftControlEnforced.Value);
            }
            if (Optional.IsDefined(IsCredentialGuardEnforced))
            {
                writer.WritePropertyName("credentialGuardEnforced"u8);
                writer.WriteBooleanValue(IsCredentialGuardEnforced.Value);
            }
            if (Optional.IsDefined(IsSmbSigningEnforced))
            {
                writer.WritePropertyName("smbSigningEnforced"u8);
                writer.WriteBooleanValue(IsSmbSigningEnforced.Value);
            }
            if (Optional.IsDefined(IsSmbClusterEncryptionEnabled))
            {
                writer.WritePropertyName("smbClusterEncryption"u8);
                writer.WriteBooleanValue(IsSmbClusterEncryptionEnabled.Value);
            }
            if (Optional.IsDefined(IsSideChannelMitigationEnforced))
            {
                writer.WritePropertyName("sideChannelMitigationEnforced"u8);
                writer.WriteBooleanValue(IsSideChannelMitigationEnforced.Value);
            }
            if (Optional.IsDefined(IsBitlockerBootVolumeEnabled))
            {
                writer.WritePropertyName("bitlockerBootVolume"u8);
                writer.WriteBooleanValue(IsBitlockerBootVolumeEnabled.Value);
            }
            if (Optional.IsDefined(AreBitlockerDataVolumesEnabled))
            {
                writer.WritePropertyName("bitlockerDataVolumes"u8);
                writer.WriteBooleanValue(AreBitlockerDataVolumesEnabled.Value);
            }
            if (Optional.IsDefined(IsWdacEnforced))
            {
                writer.WritePropertyName("wdacEnforced"u8);
                writer.WriteBooleanValue(IsWdacEnforced.Value);
            }
            if (options.Format != "W" && _serializedAdditionalRawData != null)
            {
                foreach (var item in _serializedAdditionalRawData)
                {
                    writer.WritePropertyName(item.Key);
#if NET6_0_OR_GREATER
				writer.WriteRawValue(item.Value);
#else
                    using (JsonDocument document = JsonDocument.Parse(item.Value))
                    {
                        JsonSerializer.Serialize(writer, document.RootElement);
                    }
#endif
                }
            }
        }

        HciClusterDeploymentSecuritySettings IJsonModel<HciClusterDeploymentSecuritySettings>.Create(ref Utf8JsonReader reader, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HciClusterDeploymentSecuritySettings>)this).GetFormatFromOptions(options) : options.Format;
            if (format != "J")
            {
                throw new FormatException($"The model {nameof(HciClusterDeploymentSecuritySettings)} does not support reading '{format}' format.");
            }

            using JsonDocument document = JsonDocument.ParseValue(ref reader);
            return DeserializeHciClusterDeploymentSecuritySettings(document.RootElement, options);
        }

        internal static HciClusterDeploymentSecuritySettings DeserializeHciClusterDeploymentSecuritySettings(JsonElement element, ModelReaderWriterOptions options = null)
        {
            options ??= ModelSerializationExtensions.WireOptions;

            if (element.ValueKind == JsonValueKind.Null)
            {
                return null;
            }
            bool? hvciProtection = default;
            bool? drtmProtection = default;
            bool? driftControlEnforced = default;
            bool? credentialGuardEnforced = default;
            bool? smbSigningEnforced = default;
            bool? smbClusterEncryption = default;
            bool? sideChannelMitigationEnforced = default;
            bool? bitlockerBootVolume = default;
            bool? bitlockerDataVolumes = default;
            bool? wdacEnforced = default;
            IDictionary<string, BinaryData> serializedAdditionalRawData = default;
            Dictionary<string, BinaryData> rawDataDictionary = new Dictionary<string, BinaryData>();
            foreach (var property in element.EnumerateObject())
            {
                if (property.NameEquals("hvciProtection"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    hvciProtection = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("drtmProtection"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    drtmProtection = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("driftControlEnforced"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    driftControlEnforced = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("credentialGuardEnforced"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    credentialGuardEnforced = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("smbSigningEnforced"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    smbSigningEnforced = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("smbClusterEncryption"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    smbClusterEncryption = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("sideChannelMitigationEnforced"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    sideChannelMitigationEnforced = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("bitlockerBootVolume"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    bitlockerBootVolume = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("bitlockerDataVolumes"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    bitlockerDataVolumes = property.Value.GetBoolean();
                    continue;
                }
                if (property.NameEquals("wdacEnforced"u8))
                {
                    if (property.Value.ValueKind == JsonValueKind.Null)
                    {
                        continue;
                    }
                    wdacEnforced = property.Value.GetBoolean();
                    continue;
                }
                if (options.Format != "W")
                {
                    rawDataDictionary.Add(property.Name, BinaryData.FromString(property.Value.GetRawText()));
                }
            }
            serializedAdditionalRawData = rawDataDictionary;
            return new HciClusterDeploymentSecuritySettings(
                hvciProtection,
                drtmProtection,
                driftControlEnforced,
                credentialGuardEnforced,
                smbSigningEnforced,
                smbClusterEncryption,
                sideChannelMitigationEnforced,
                bitlockerBootVolume,
                bitlockerDataVolumes,
                wdacEnforced,
                serializedAdditionalRawData);
        }

        private BinaryData SerializeBicep(ModelReaderWriterOptions options)
        {
            StringBuilder builder = new StringBuilder();
            BicepModelReaderWriterOptions bicepOptions = options as BicepModelReaderWriterOptions;
            IDictionary<string, string> propertyOverrides = null;
            bool hasObjectOverride = bicepOptions != null && bicepOptions.PropertyOverrides.TryGetValue(this, out propertyOverrides);
            bool hasPropertyOverride = false;
            string propertyOverride = null;

            builder.AppendLine("{");

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsHvciProtectionEnabled), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  hvciProtection: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsHvciProtectionEnabled))
                {
                    builder.Append("  hvciProtection: ");
                    var boolValue = IsHvciProtectionEnabled.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsDrtmProtectionEnabled), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  drtmProtection: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsDrtmProtectionEnabled))
                {
                    builder.Append("  drtmProtection: ");
                    var boolValue = IsDrtmProtectionEnabled.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsDriftControlEnforced), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  driftControlEnforced: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsDriftControlEnforced))
                {
                    builder.Append("  driftControlEnforced: ");
                    var boolValue = IsDriftControlEnforced.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsCredentialGuardEnforced), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  credentialGuardEnforced: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsCredentialGuardEnforced))
                {
                    builder.Append("  credentialGuardEnforced: ");
                    var boolValue = IsCredentialGuardEnforced.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsSmbSigningEnforced), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  smbSigningEnforced: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsSmbSigningEnforced))
                {
                    builder.Append("  smbSigningEnforced: ");
                    var boolValue = IsSmbSigningEnforced.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsSmbClusterEncryptionEnabled), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  smbClusterEncryption: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsSmbClusterEncryptionEnabled))
                {
                    builder.Append("  smbClusterEncryption: ");
                    var boolValue = IsSmbClusterEncryptionEnabled.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsSideChannelMitigationEnforced), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  sideChannelMitigationEnforced: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsSideChannelMitigationEnforced))
                {
                    builder.Append("  sideChannelMitigationEnforced: ");
                    var boolValue = IsSideChannelMitigationEnforced.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsBitlockerBootVolumeEnabled), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  bitlockerBootVolume: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsBitlockerBootVolumeEnabled))
                {
                    builder.Append("  bitlockerBootVolume: ");
                    var boolValue = IsBitlockerBootVolumeEnabled.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(AreBitlockerDataVolumesEnabled), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  bitlockerDataVolumes: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(AreBitlockerDataVolumesEnabled))
                {
                    builder.Append("  bitlockerDataVolumes: ");
                    var boolValue = AreBitlockerDataVolumesEnabled.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            hasPropertyOverride = hasObjectOverride && propertyOverrides.TryGetValue(nameof(IsWdacEnforced), out propertyOverride);
            if (hasPropertyOverride)
            {
                builder.Append("  wdacEnforced: ");
                builder.AppendLine(propertyOverride);
            }
            else
            {
                if (Optional.IsDefined(IsWdacEnforced))
                {
                    builder.Append("  wdacEnforced: ");
                    var boolValue = IsWdacEnforced.Value == true ? "true" : "false";
                    builder.AppendLine($"{boolValue}");
                }
            }

            builder.AppendLine("}");
            return BinaryData.FromString(builder.ToString());
        }

        BinaryData IPersistableModel<HciClusterDeploymentSecuritySettings>.Write(ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HciClusterDeploymentSecuritySettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    return ModelReaderWriter.Write(this, options);
                case "bicep":
                    return SerializeBicep(options);
                default:
                    throw new FormatException($"The model {nameof(HciClusterDeploymentSecuritySettings)} does not support writing '{options.Format}' format.");
            }
        }

        HciClusterDeploymentSecuritySettings IPersistableModel<HciClusterDeploymentSecuritySettings>.Create(BinaryData data, ModelReaderWriterOptions options)
        {
            var format = options.Format == "W" ? ((IPersistableModel<HciClusterDeploymentSecuritySettings>)this).GetFormatFromOptions(options) : options.Format;

            switch (format)
            {
                case "J":
                    {
                        using JsonDocument document = JsonDocument.Parse(data);
                        return DeserializeHciClusterDeploymentSecuritySettings(document.RootElement, options);
                    }
                default:
                    throw new FormatException($"The model {nameof(HciClusterDeploymentSecuritySettings)} does not support reading '{options.Format}' format.");
            }
        }

        string IPersistableModel<HciClusterDeploymentSecuritySettings>.GetFormatFromOptions(ModelReaderWriterOptions options) => "J";
    }
}
