// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.

// <auto-generated/>

#nullable disable

using System;
using System.Collections.Generic;

namespace Azure.ResourceManager.Hci.Models
{
    /// <summary> The Deployment data of AzureStackHCI Cluster. </summary>
    public partial class HciClusterDeploymentInfo
    {
        /// <summary>
        /// Keeps track of any properties unknown to the library.
        /// <para>
        /// To assign an object to the value of this property use <see cref="BinaryData.FromObjectAsJson{T}(T, System.Text.Json.JsonSerializerOptions?)"/>.
        /// </para>
        /// <para>
        /// To assign an already formatted json string to this property use <see cref="BinaryData.FromString(string)"/>.
        /// </para>
        /// <para>
        /// Examples:
        /// <list type="bullet">
        /// <item>
        /// <term>BinaryData.FromObjectAsJson("foo")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("\"foo\"")</term>
        /// <description>Creates a payload of "foo".</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromObjectAsJson(new { key = "value" })</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// <item>
        /// <term>BinaryData.FromString("{\"key\": \"value\"}")</term>
        /// <description>Creates a payload of { "key": "value" }.</description>
        /// </item>
        /// </list>
        /// </para>
        /// </summary>
        private IDictionary<string, BinaryData> _serializedAdditionalRawData;

        /// <summary> Initializes a new instance of <see cref="HciClusterDeploymentInfo"/>. </summary>
        public HciClusterDeploymentInfo()
        {
            InfrastructureNetwork = new ChangeTrackingList<DeploymentSettingInfrastructureNetwork>();
            PhysicalNodes = new ChangeTrackingList<DeploymentSettingPhysicalNodes>();
            Secrets = new ChangeTrackingList<EceDeploymentSecrets>();
        }

        /// <summary> Initializes a new instance of <see cref="HciClusterDeploymentInfo"/>. </summary>
        /// <param name="securitySettings"> SecuritySettings to deploy AzureStackHCI Cluster. </param>
        /// <param name="observability"> Observability config to deploy AzureStackHCI Cluster. </param>
        /// <param name="cluster"> Observability config to deploy AzureStackHCI Cluster. </param>
        /// <param name="storage"> Storage config to deploy AzureStackHCI Cluster. </param>
        /// <param name="namingPrefix"> naming prefix to deploy cluster. </param>
        /// <param name="domainFqdn"> FQDN to deploy cluster. </param>
        /// <param name="infrastructureNetwork"> InfrastructureNetwork config to deploy AzureStackHCI Cluster. </param>
        /// <param name="physicalNodes"> list of physical nodes config to deploy AzureStackHCI Cluster. </param>
        /// <param name="hostNetwork"> HostNetwork config to deploy AzureStackHCI Cluster. </param>
        /// <param name="sdnIntegration"> SDN Integration config to deploy AzureStackHCI Cluster. </param>
        /// <param name="adouPath"> The path to the Active Directory Organizational Unit container object prepared for the deployment. </param>
        /// <param name="secretsLocation"> Azure keyvault endpoint. This property is deprecated from 2023-12-01-preview. Please use secrets property instead. </param>
        /// <param name="secrets"> secrets used for cloud deployment. </param>
        /// <param name="optionalServices"> OptionalServices config to deploy AzureStackHCI Cluster. </param>
        /// <param name="serializedAdditionalRawData"> Keeps track of any properties unknown to the library. </param>
        internal HciClusterDeploymentInfo(HciClusterDeploymentSecuritySettings securitySettings, DeploymentSettingObservability observability, HciDeploymentCluster cluster, DeploymentSettingStorage storage, string namingPrefix, string domainFqdn, IList<DeploymentSettingInfrastructureNetwork> infrastructureNetwork, IList<DeploymentSettingPhysicalNodes> physicalNodes, DeploymentSettingHostNetwork hostNetwork, SdnIntegration sdnIntegration, string adouPath, string secretsLocation, IList<EceDeploymentSecrets> secrets, OptionalServices optionalServices, IDictionary<string, BinaryData> serializedAdditionalRawData)
        {
            SecuritySettings = securitySettings;
            Observability = observability;
            Cluster = cluster;
            Storage = storage;
            NamingPrefix = namingPrefix;
            DomainFqdn = domainFqdn;
            InfrastructureNetwork = infrastructureNetwork;
            PhysicalNodes = physicalNodes;
            HostNetwork = hostNetwork;
            SdnIntegration = sdnIntegration;
            AdouPath = adouPath;
            SecretsLocation = secretsLocation;
            Secrets = secrets;
            OptionalServices = optionalServices;
            _serializedAdditionalRawData = serializedAdditionalRawData;
        }

        /// <summary> SecuritySettings to deploy AzureStackHCI Cluster. </summary>
        [WirePath("securitySettings")]
        public HciClusterDeploymentSecuritySettings SecuritySettings { get; set; }
        /// <summary> Observability config to deploy AzureStackHCI Cluster. </summary>
        [WirePath("observability")]
        public DeploymentSettingObservability Observability { get; set; }
        /// <summary> Observability config to deploy AzureStackHCI Cluster. </summary>
        [WirePath("cluster")]
        public HciDeploymentCluster Cluster { get; set; }
        /// <summary> Storage config to deploy AzureStackHCI Cluster. </summary>
        internal DeploymentSettingStorage Storage { get; set; }
        /// <summary> By default, this mode is set to Express and your storage is configured as per best practices based on the number of nodes in the cluster. Allowed values are 'Express','InfraOnly', 'KeepStorage'. </summary>
        [WirePath("storage.configurationMode")]
        public string StorageConfigurationMode
        {
            get => Storage is null ? default : Storage.ConfigurationMode;
            set
            {
                if (Storage is null)
                    Storage = new DeploymentSettingStorage();
                Storage.ConfigurationMode = value;
            }
        }

        /// <summary> naming prefix to deploy cluster. </summary>
        [WirePath("namingPrefix")]
        public string NamingPrefix { get; set; }
        /// <summary> FQDN to deploy cluster. </summary>
        [WirePath("domainFqdn")]
        public string DomainFqdn { get; set; }
        /// <summary> InfrastructureNetwork config to deploy AzureStackHCI Cluster. </summary>
        [WirePath("infrastructureNetwork")]
        public IList<DeploymentSettingInfrastructureNetwork> InfrastructureNetwork { get; }
        /// <summary> list of physical nodes config to deploy AzureStackHCI Cluster. </summary>
        [WirePath("physicalNodes")]
        public IList<DeploymentSettingPhysicalNodes> PhysicalNodes { get; }
        /// <summary> HostNetwork config to deploy AzureStackHCI Cluster. </summary>
        [WirePath("hostNetwork")]
        public DeploymentSettingHostNetwork HostNetwork { get; set; }
        /// <summary> SDN Integration config to deploy AzureStackHCI Cluster. </summary>
        internal SdnIntegration SdnIntegration { get; set; }
        /// <summary> network controller config for SDN Integration to deploy AzureStackHCI Cluster. </summary>
        [WirePath("sdnIntegration.networkController")]
        public DeploymentSettingNetworkController SdnIntegrationNetworkController
        {
            get => SdnIntegration is null ? default : SdnIntegration.NetworkController;
            set
            {
                if (SdnIntegration is null)
                    SdnIntegration = new SdnIntegration();
                SdnIntegration.NetworkController = value;
            }
        }

        /// <summary> The path to the Active Directory Organizational Unit container object prepared for the deployment. </summary>
        [WirePath("adouPath")]
        public string AdouPath { get; set; }
        /// <summary> Azure keyvault endpoint. This property is deprecated from 2023-12-01-preview. Please use secrets property instead. </summary>
        [WirePath("secretsLocation")]
        public string SecretsLocation { get; set; }
        /// <summary> secrets used for cloud deployment. </summary>
        [WirePath("secrets")]
        public IList<EceDeploymentSecrets> Secrets { get; }
        /// <summary> OptionalServices config to deploy AzureStackHCI Cluster. </summary>
        internal OptionalServices OptionalServices { get; set; }
        /// <summary> The name of custom location. </summary>
        [WirePath("optionalServices.customLocation")]
        public string OptionalServicesCustomLocation
        {
            get => OptionalServices is null ? default : OptionalServices.CustomLocation;
            set
            {
                if (OptionalServices is null)
                    OptionalServices = new OptionalServices();
                OptionalServices.CustomLocation = value;
            }
        }
    }
}
